<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Todaystimetable_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }
	public function getTimetable($dayid,$teacherid)
	{
		$this->db->select("t.*, c.class_name,s.section_name,sb.subject_name")->from("weekly_timetable as t");
        $this->db->where('t.teacherid', $teacherid);
		$this->db->where('t.dayid', $dayid);
		$this->db->join('classes as c', 'c.classid=t.classid');
		$this->db->join('sections as s', 's.sectionid=t.sectionid');
		$this->db->join('subjects as sb', 'sb.subjectid=t.subjectid');
		//$this->db->where('l.datetime',date('Y-m-d'));
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getLessoninfo($teacherid,$subjectid){
		$this->db->select("l.description as lesson,l.id as lessonid")->from("lesson_plan as l");
        $this->db->where('l.teacherid', $teacherid);
		$this->db->where('l.datetime',date('Y-m-d'));
		$this->db->where('l.subjectid',$subjectid);
		$query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function getClassinfo($teacherid,$period,$classid,$sectionid){
		$this->db->select("c.class_note,c.what_done")->from("class_feedback as c");
        $this->db->where('c.teacherid', $teacherid);
		$this->db->where('c.period_no',$period);
		$this->db->where('c.date',date('Y-m-d'));
		$query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function today_subtimetable($teacherid)
	{
		$this->db->select(" c.class_name,s.section_name,sb.subject_name,wt.classid,wt.sectionid,wt.subjectid,wt.period_no,wt.start_time,wt.end_time")->from("substitute_teacher as st");
        $this->db->where('st.teacherid', $teacherid);
		$this->db->where('st.date',date('Y-m-d'));
		$this->db->join('weekly_timetable as wt', 'wt.id=st.weekly_time_id');
		
		//$this->db->join('teachers as t', 'st.teacherid=t.teacherid');
		$this->db->join('classes as c', 'c.classid=wt.classid');
		$this->db->join('sections as s', 's.sectionid=wt.sectionid');
		$this->db->join('subjects as sb', 'sb.subjectid=wt.subjectid');
		$query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
}

?>
