<?php



defined('BASEPATH') OR exit('No direct script access allowed');



class Grading_model extends CI_Model {



    public function __construct() {

        parent::__construct();

    }


   public function get_class_section_info($branch_id , $teacher_id)
	{
	   $this->db->select("*");
	   $this->db->where("tbl_assign_teacher.branch_id" , $branch_id);
	   $this->db->where("tbl_assign_teacher.fkteacher_id" , $teacher_id);
	   $this->db->from("tbl_assign_teacher");
	   $this->db->join("classes" , "tbl_assign_teacher.fkclass_id = classes.classid");
	   $this->db->join("sections" , "tbl_assign_teacher.fksection_id = sections.sectionid");
	   $this->db->join("teacher" , "tbl_assign_teacher.fkteacher_id = teacher.teacherid");
	   $query = $this->db->get();
	   return $query->result_array();	
	}
	
  public function get_subject_class($classid , $branch_id)
  {
	$this->db->select("*");
	$this->db->where("tbl_assign_subject.branch_id" , $branch_id);
	$this->db->where("tbl_assign_subject.fkclass_id" , $classid);
	$this->db->from("tbl_assign_subject");
	$this->db->join("classes" , "tbl_assign_subject.fkclass_id = classes.classid");
	$this->db->join("subjects" , "tbl_assign_subject.fksubject_id = subjects.subjectid");
	$query = $this->db->get();
	return $query->result_array();  
  }
  
  public function get_student($class_id , $section_id , $branch_id)
  {
    $this->db->where("classid" , $class_id);
	$this->db->where("sectionid" , $section_id);
	$this->db->where("branchid" , $branch_id);
	$query = $this->db->get("students");
	return $query->result_array();
		  
  }	
  
  public function get_class_info($class_id)
  {
	$this->db->where("classid" , $class_id);
	$query = $this->db->get("classes");
	return $query->row_array();  
  }
  
  public function get_subject_info($subject_id)
  {
	$this->db->where("subjectid" , $subject_id);
	$query = $this->db->get("subjects");
	return $query->row_array();  
  }
  
  public function get_section_info($section_id)
  {
	$this->db->where("sectionid" , $section_id);
	$query = $this->db->get("sections");
	return $query->row_array();  
  }
  
  public function add_marks_setting($class_id , $section_id , $subject_id , $branch_id)
  {
	$term = $this->input->post("term");
	$month = $this->input->post("month");
	 
	$this->db->where("fkbranch_id" , $branch_id);
	$this->db->where("fkteacher_id" , $this->session->userdata('teacher_id'));
	$this->db->where("fkclass_id" , $class_id);
	$this->db->where("fksection_id" , $section_id);
	$this->db->where("fksubject_id" , $subject_id);
	
	$this->db->where("term" , $term);
	$this->db->where("month" , $month);
	
	$this->db->delete("tbl_add_marks_settings"); 
	 
	$term = $this->input->post("term");
	$month = $this->input->post("month");
	 
	
	   
	$data_insrt = array(
						  "fkbranch_id" => $branch_id,
						  "fkteacher_id" => $this->session->userdata('teacher_id'),
						  "fkclass_id" => $class_id,
						  "fksection_id" => $section_id,
						  "fksubject_id" => $subject_id,
						  "term" => $term,
						  "month" => $month,
						  
						  "total_hw" => $this->input->post("total_hw"),
						  "total_hw_count" => $this->input->post("total_hw_count"),
						  "total_attendance" => $this->input->post("total_attendance"),
						  "total_attendance_count" => $this->input->post("total_attendance_count"),
						  "total_assessment" => $this->input->post("total_assessment"),
						  "total_assessment_count" => $this->input->post("total_assessment_count"),
						  "total_assessment_marks" => $this->input->post("total_assessment_marks")
						);
	$this->db->insert("tbl_add_marks_settings" , $data_insrt);					 
	
	 
  }
	 
  public function add_marks($class_id , $section_id , $subject_id , $branch_id,$term_id,$month_id)
  {
	$this->db->where("fkbranch_id" , $branch_id);
	$this->db->where("fkteacher_id" , $this->session->userdata('teacher_id'));
	$this->db->where("fkclass_id" , $class_id);
	$this->db->where("fksection_id" , $section_id);
	$this->db->where("fksubject_id" , $subject_id);
	$this->db->where("term" , $term_id);
	$this->db->where("month" , $month_id);
	$this->db->delete("tbl_add_marks"); 
	 
	 
	 $mark = $this->input->post("mark");
	
	 foreach($mark as $key => $val)
	 {
	   
		 $data_insrt = array(
							  "fkbranch_id" => $branch_id,
							  "fkteacher_id" => $this->session->userdata('teacher_id'),
							  "fkclass_id" => $class_id,
							  "fksection_id" => $section_id,
							  "fksubject_id" => $subject_id,
							  "term" => $term_id,
							  "month" => $month_id,
							  "fkstudent_id" => $key,
							  
							  "total_hw" => $val["total_hw"],
							  "avg_hw" => $val["avg_hw"],
							  "total_att" => $val["total_att"],
							  "avg_att" => $val["avg_att"],
							  "total_asses" => json_encode($val["total_asses"]),
							  "avg_asses" => $val["avg_asses"],
							  
							  
							  "average" => $val["average"],
							  "co_efficient" => $val["co_efficient"],
							  "total" => $val["average"] * $val["co_efficient"]
		                   );
		$this->db->insert("tbl_add_marks" , $data_insrt);					 
	   	 
	 }
  }
	 
  public function get_marks($class_id , $section_id , $subject_id , $branch_id, $term_id,$month_id)
  {
	$this->db->where("fkbranch_id" ,  $branch_id);
	$this->db->where("fkteacher_id" , $this->session->userdata('teacher_id'));
	$this->db->where("fkclass_id" ,   $class_id);
	$this->db->where("fksection_id" , $section_id);
	$this->db->where("fksubject_id" , $subject_id);
	$this->db->where("term" , $term_id);
	$this->db->where("month" , $month_id);
	
	$query = $this->db->get("tbl_add_marks");
	return $query->row_array(); 
	 
  }
  public function get_marks_setting($class_id , $section_id , $subject_id , $branch_id , $term_id,$month_id)
  {
	$this->db->where("fkbranch_id" , $branch_id);
	$this->db->where("fkteacher_id" , $this->session->userdata('teacher_id'));
	$this->db->where("fkclass_id" , $class_id);
	$this->db->where("fksection_id" , $section_id);
	$this->db->where("fksubject_id" , $subject_id);
	$this->db->where("term" , $term_id);
	$this->db->where("month" , $month_id);
	$query = $this->db->get("tbl_add_marks_settings");
	return $query->row_array(); 
	 
  }
	
}