<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Attendance_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }
	public function getAttendance($teacherid)
	{
		$this->db->select("*")->from("teacher_attendance");
        $this->db->where('teacherid', $teacherid);
		//$this->db->where('date',date('Y-m-d'));
		$this->db->order_by('id', 'desc');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function getAttendanceHistory($teacherid)
	{
		$this->db->select("a.*")->from("teacher_attendance as a");
        $this->db->where('a.teacherid', $teacherid);
		$this->db->order_by('a.id', 'desc');
		$this->db->limit(20);
        $query = $this->db->get();
        if ($query->num_rows() >  0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getMonthAbsents($teacherid)
	{
		$this->db->select("count(*) as total_attendance")->from("teacher_attendance");
        $this->db->where('teacherid', $teacherid);
		$this->db->where('status', 'A');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}

	public function reply_teacher($post)
	{
		$data['teacher_reply'] = $post['teacher_reply'];
        $this->db->where("id", $post['id']);
        $this->db->update("teacher_attendance", $data);
	}
	public function get_attendance_count($post)
	{
		$post['to_date'] = date('Y-m-d',strtotime($post['to_date'])) ;
		$post['from_date'] = date('Y-m-d',strtotime($post['from_date'])) ;
		$this->db->select("count(*) as total_attendance")->from("teacher_attendance");
        $this->db->where('teacherid', $post['teacher_id']);
		$this->db->where('date <=', $post['to_date']);
		$this->db->where('date >=', $post['from_date']);
		$this->db->where('status', 'A');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
		
	}

}

?>
