<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Addattendance_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }
	public function getAttendance($teacherid)
	{
		$this->db->select("*")->from("teacher_attendance");
        $this->db->where('teacherid', $teacherid);
		$this->db->where('date',date('Y-m-d'));
		$this->db->order_by('id', 'desc');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function getStudent($classid,$sectionid,$period,$subjectid)
	{
		$this->db->select("*")->from("students");
        $this->db->where('classid', $classid);
		$this->db->where('sectionid', $sectionid);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            $students = $query->result();
			if($students)
			{ 
				foreach ($students as$key=> $t) 
				{ 
					$this->db->select("status,message")->from("attendance");
					$this->db->where('date',date('Y-m-d'));
					$this->db->where('studentid',$t->stdid);
					$this->db->where('classid',$classid);
					$this->db->where('sectionid',$sectionid);
					$this->db->where('period_no',$period);
					$this->db->where('subjectid',$subjectid);
					$query = $this->db->get();
					if ($query->num_rows() > 0) {
						$attend = $query->row();
					} else {
						$attend = FALSE;
					}
					$t->attendance = $attend;
				}
				return $students;
			}
        } else {
            return FALSE;
        }
	}
	public function Addattendance($post)
	{
		$this->db->where('period_no', $post['period_no']);
		$this->db->where('date', $post['date']);
		$this->db->where('teacherid', $post['teacherid']);
		$this->db->where('classid', $post['classid']);
		$this->db->where('sectionid', $post['sectionid']);
		$this->db->where('subjectid', $post['subjectid']);
		$this->db->where('studentid', $post['studentid']);
        $this->db->delete('attendance');
		
		if($post['status'])
		{
			$this->db->set($post);
			$this->db->insert("attendance");
			return $this->db->insert_id();
		}
	}
	public function gethomework($classid,$sectionid,$subjectid,$teacherid, $submission_date = null)
	{
		// $submission_date = $submission_date == null ? date('Y-m-d') : $submission_date;
		$this->db->select("description,images,document,submission_date")->from("homework");
        $this->db->where('classid', $classid);
		$this->db->where('sectionid', $sectionid);
		$this->db->where('subjectid', $subjectid);
		$this->db->where('teacherid', $teacherid);
		// $this->db->where('submission_date', $submission_date);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function classfeedback($classid,$sectionid,$subjectid,$teacherid)
	{
		$this->db->select("class_note,what_done")->from("class_feedback");
        $this->db->where('classid', $classid);
		$this->db->where('sectionid', $sectionid);
		$this->db->where('teacherid', $teacherid);
		$this->db->where('date', date('Y-m-d'));
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function countAttendance($date,$type,$classid,$sectionid,$period)
	{
		$this->db->select("a.id")->from("attendance a");
		$this->db->where('a.date',$date);
		$this->db->where('a.status',$type);
		$this->db->where('a.classid',$classid);
		$this->db->where('a.sectionid',$sectionid);
		$this->db->where('a.period_no',$period);
		 $query = $this->db->get();
		if ($query->num_rows() > 0) {
			return $query->num_rows();
		} else {
			return 0;
		}
	}
	public function getStudentParentReg($stdid)
	{
		$this->db->select('p.reg_id,p.PR_number,p.device_token,p.father_mobile');
		$this->db->join('parents p','p.PR_number=s.PR_number');
		$this->db->where('s.stdid',$stdid);
		$query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
			return $query->row_array();
        } else {
            return "";
        }
	}
}

?>
