<?php



defined('BASEPATH') OR exit('No direct script access allowed');



class StdAbsents_model extends CI_Model {



    public function __construct() {

        parent::__construct();

    }

	public function getTeacher()

	{

		$this->db->select("t.*")->from("teacher t");

		$this->db->where('t.branchid', $this->session->userdata('principle_branchid'));

        $query = $this->db->get();

        if ($query->num_rows() > 0) {

            return $query->result();

        } else {

            return FALSE;

        }

	}

	public function getstdAbsents($date,$classid,$sectionid)

	{

		$this->db->select("a.*, s.GR_number, s.name, c.class_name, sec.section_name")->from("attendance as a");

		if($date)

		{

			$this->db->where('a.date',$date);

		}

		else

		{

			$this->db->where('a.date', date('Y-m-d'));

		}

		if($classid)

		{

			$this->db->where('a.classid',$classid);

		}

		if($sectionid)

		{

			$this->db->where('a.sectionid',$sectionid);

		}

		$this->db->where('a.status', 'A');

		$this->db->join("teacher t","t.teacherid=a.teacherid");

		$this->db->join("students s","s.stdid=a.studentid");

		$this->db->join("classes c","c.classid=s.classid");

		$this->db->join("sections sec","sec.sectionid=s.sectionid");

		$this->db->distinct();

		$this->db->group_by("s.GR_number","ASC");

		$this->db->order_by("c.class_name","ASC");

		$this->db->order_by("sec.section_name","ASC");

		$this->db->where('t.branchid', $this->session->userdata('principle_branchid'));

        $query = $this->db->get();

		

        if ($query->num_rows() > 0) {

            return $query->result();

        } else {

            return "";

        }

	}

	public function getteacherAttendance($id)

	{

		$this->db->select("a.*,teacher_name")->from("teacher_attendance a");

		$this->db->where('a.teacherid',$id);

		$this->db->like('a.date',date('Y-m'));

		$this->db->join('teacher t','t.teacherid=a.teacherid');

		 $query = $this->db->get();

		if ($query->num_rows() > 0) {

			return $query->result();

		} else {

			return FALSE;

		}

	}

	public function classfeedback($class,$section,$period,$date)

	{

		$this->db->select("class_note,what_done")->from("class_feedback");

        $this->db->where('classid', $class);

		$this->db->where('sectionid', $section);

		$this->db->where('period_no', $period);

		$this->db->where('date', $date);

        $query = $this->db->get();

        if ($query->num_rows() > 0) {

            return $query->row();

        } else {

            return FALSE;

        }

	}

	public function countAttendance($class,$section,$period,$date,$type)

	{

		$this->db->select("a.id")->from("attendance a");

		$this->db->where('a.date',$date);

		$this->db->where('a.classid',$class);

		$this->db->where('a.sectionid',$section);

		$this->db->where('a.period_no',$period);

		$this->db->where('a.status',$type);

		 $query = $this->db->get();

		if ($query->num_rows() > 0) {

			return $query->num_rows();

		} else {

			return 0;

		}

	}

	public function Updateattendance($post)

	{

		

		

		if($post['status'])

		{

			$this->db->where('date', $post['date']);

			$this->db->where('studentid', $post['studentid']);

			$this->db->where('classid', $post['classid']);

			$this->db->where('sectionid', $post['sectionid']);

			$this->db->where('period_no', $post['period_no']);

			$this->db->delete('attendance');

		

			$this->db->set($post);

			$this->db->insert("attendance");

			return $this->db->insert_id();

		}

	}

	function add_note()

	{

		$post['class_note'] = $_POST['class_note'];

		$post['what_done'] = $_POST['what_done'];

		$post['classid'] = $_POST['classid'];

		$post['sectionid'] = $_POST['sectionid'];

		$post['period_no'] = $_POST['period'];

		$post['date'] =  $_POST['date'];

		//update

		$this->db->where('date', date('Y-m-d'));

        $this->db->delete('class_feedback');

		

		$post['date'] = date('Y-m-d');

		$this->db->set($post);

        $insert = $this->db->insert("class_feedback");

        return $this->db->insert_id();

	}

	function removeAttendance($class,$section,$period,$date)

	{

		$this->db->where('classid', $class);

		$this->db->where('sectionid', $section);

		$this->db->where('period_no', $period);

		$this->db->where('date', $date);

		

        $this->db->delete('attendance');

	}

}



?>

