<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Accountant_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }
	public function getClasses()
	{
		$this->db->select('c.*');
		$this->db->where('c.classid !=','');
        $query = $this->db->get('classes c');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function addMonthlyfee($post)
	{
		$this->db->set($post);
        $this->db->insert('fee_structure');
        return $this->db->insert_id();
	}
	public function updateMonthlyfee($post,$id)
	{
		$this->db->where('id', $id);
        $this->db->set($post);
        $this->db->update('fee_structure');
        return $id;
	}
	public function updateStudentfee($post,$id)
	{
		$this->db->where('id', $id);
        $this->db->set($post);
        $this->db->update('fee_history');
        return $id;
	}

	public function getMonthlyfee($id='')
	{
		$this->db->select('f.*,c.class_name');
		if($id)
		{
			$this->db->where('id',$id);
		}
		$this->db->join('classes c','f.classid=c.classid');
        $query = $this->db->get('fee_structure f');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getStudents()
	{
		$this->db->select('s.GR_number');
		$this->db->order_by('s.GR_number','ASC');
        $query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	
	public function addStudentfee($post)
	{
		$post['duedate'] = date('Y-m')."-1";
		$this->db->set($post);
        $this->db->insert('fee_history');
        return $this->db->insert_id();
	}
	public function getStudentfee($id='')
	{
		$this->db->select('f.*,c.class_name,h.GR_number,h.paydate,h.id as historyid,s.name,sec.section_name');
		$this->db->join('fee_history h','h.fee_id=f.id');
		$this->db->join('students s','s.GR_number=h.GR_number');
		$this->db->join('classes c','s.classid=c.classid');
		$this->db->join('sections sec','sec.sectionid=s.sectionid');
		if($id)
		{
			$this->db->where('h.id',$id);
		}
        $query = $this->db->get('fee_structure f');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function checkStudentfeeforCurrentMonth($gr_number='')
	{
		$this->db->select('a.GR_number');
		$this->db->where('a.GR_number',$gr_number);
		$this->db->like('a.paydate',date('Y-m'));
        $query = $this->db->get('fee_history a');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
}

?>
