<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class MarkStudent_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }
	public function getstdList($classid,$sectionid)
	{
		$this->db->select("s.stdid, s.GR_number, s.name, c.class_name, sec.section_name");
		$this->db->where('s.classid', $classid);
		$this->db->where('s.sectionid', $sectionid);
		$this->db->where('s.branchid', $this->session->userdata('principal_branchid'));
		$this->db->join('classes c','c.classid=s.classid');
		$this->db->join('sections sec','sec.sectionid=s.sectionid');
		$query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return "";
        }
	}
	public function getSubjectid($dayid,$classid , $sectionid)
	{
		$this->db->select("t.subjectid,t.period_no,t.teacherid,teacher.teacher_name")->from("weekly_timetable as t");
		$this->db->where('t.classid', $classid);
		$this->db->where('t.sectionid', $sectionid);
		$this->db->where('t.dayid', $dayid);
		$this->db->join('teacher','teacher.teacherid=t.teacherid');
		$this->db->order_by('t.period_no','ASC');
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
			return $query->row();
        } else {
            return 0;
        }
	}
	public function getTeacher($classid,$sectionid)
	{
		$this->db->select("t.teacherid")->from("teacher as t");
        $this->db->where('t.classid', $classid);
		$this->db->where('t.sectionid', $sectionid);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
			return $query->row()->teacherid;
        } else {
            return 0;
        }
	}

	public function getAttendance($class='',$section='',$period='',$date='')
	{
		if($date)
		{
			$this->db->select("s.name,s.stdid,c.class_name,sec.section_name,s.classid,sec.sectionid")->from("students s");
			//$this->db->limit(30);
			$this->db->where('s.classid',$class);
			$this->db->where('s.sectionid',$section);
			$this->db->join('classes c','c.classid=s.classid');
			$this->db->join('sections sec','sec.sectionid=s.sectionid');
			//$this->db->where('s.branchid', $this->session->userdata('principal_branchid'));
			$query = $this->db->get();
			if ($query->num_rows() > 0) {
				$students = $query->result();
			} else {
				$students = FALSE;
			}
			if($students)
			{
				foreach ($students as$key=> $t) 
				{ 
					$this->db->select("status,date,period_no,message,subjectid,teacherid")->from("attendance");
					$this->db->where('date',$date);
					$this->db->where('studentid',$t->stdid);
					$this->db->where('classid',$class);
					$this->db->where('sectionid',$section);
					$this->db->where('period_no',$period);
					$query = $this->db->get();
					if ($query->num_rows() > 0) {
						$attend = $query->row();
					} else {
						$attend = FALSE;
					}
					$t->attendance = $attend;
				}
			}
			return $students;
		}
		else{
			$this->db->select("a.*,c.class_name,sec.section_name,sb.subject_name,t.teacher_name")->from("attendance a");
			//$this->db->limit(30);
			$this->db->join('students s','s.stdid=a.studentid');
			$this->db->join('classes c','c.classid=s.classid');
			$this->db->join('sections sec','sec.sectionid=s.sectionid');
			$this->db->join('subjects sb','sb.subjectid=a.subjectid');
			$this->db->join('teacher t','t.teacherid=a.teacherid');
			$this->db->where('t.branchid', $this->session->userdata('principal_branchid'));
			$this->db->where('a.date', date('Y-m-d'));
			$this->db->distinct();
			$this->db->group_by('t.teacherid');
			$this->db->order_by('c.class_name','ASC');
			$this->db->order_by('sec.section_name','ASC');
			 $query = $this->db->get();
			if ($query->num_rows() > 0) {
				return $query->result();
			} else {
				return FALSE;
			}
		}
	}
	public function getteacherAttendance($id)
	{
		$this->db->select("a.*,teacher_name")->from("teacher_attendance a");
		$this->db->where('a.teacherid',$id);
		$this->db->like('a.date',date('Y-m'));
		$this->db->join('teacher t','t.teacherid=a.teacherid');
		 $query = $this->db->get();
		if ($query->num_rows() > 0) {
			return $query->result();
		} else {
			return FALSE;
		}
	}
	public function classfeedback($class,$section,$period,$date)
	{
		$this->db->select("class_note,what_done")->from("class_feedback");
        $this->db->where('classid', $class);
		$this->db->where('sectionid', $section);
		$this->db->where('period_no', $period);
		$this->db->where('date', $date);
        $query = $this->db->get();
        if ($query->num_rows() > 0) {
            return $query->row();
        } else {
            return FALSE;
        }
	}
	public function countAttendance($class,$section,$period,$date,$type)
	{
		$this->db->select("a.id")->from("attendance a");
		$this->db->where('a.date',$date);
		$this->db->where('a.classid',$class);
		$this->db->where('a.sectionid',$section);
		$this->db->where('a.period_no',$period);
		$this->db->where('a.status',$type);
		 $query = $this->db->get();
		if ($query->num_rows() > 0) {
			return $query->num_rows();
		} else {
			return 0;
		}
	}
	public function Updateattendance($post)
	{
		
		
		if($post['status'])
		{
			$this->db->where('date', $post['date']);
			$this->db->where('studentid', $post['studentid']);
			$this->db->where('classid', $post['classid']);
			$this->db->where('sectionid', $post['sectionid']);
			$this->db->where('period_no', $post['period_no']);
			$this->db->delete('attendance');
		
			$this->db->set($post);
			$this->db->insert("attendance");
			return $this->db->insert_id();
		}
	}
	function add_note()
	{
		$post['class_note'] = $_POST['class_note'];
		$post['what_done'] = $_POST['what_done'];
		$post['classid'] = $_POST['classid'];
		$post['sectionid'] = $_POST['sectionid'];
		$post['period_no'] = $_POST['period'];
		$post['date'] =  $_POST['date'];
		//update
		$this->db->where('date', date('Y-m-d'));
        $this->db->delete('class_feedback');
		
		$post['date'] = date('Y-m-d');
		$this->db->set($post);
        $insert = $this->db->insert("class_feedback");
        return $this->db->insert_id();
	}
	function removeAttendance($class,$section,$period,$date)
	{
		$this->db->where('classid', $class);
		$this->db->where('sectionid', $section);
		$this->db->where('period_no', $period);
		$this->db->where('date', $date);
		
        $this->db->delete('attendance');
	}
	public function getStudentParentReg($stdid)
	{
		$this->db->select('p.reg_id,p.PR_number,p.device_token,p.father_mobile');
		$this->db->join('parents p','p.PR_number=s.PR_number');
		$this->db->where('s.stdid',$stdid);
		$query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
			return $query->row_array();
        } else {
            return "";
        }
	}
}

?>
