<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Accountant_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }
	public function getMonths()
	{
		$this->db->select('m.*');
		$this->db->where('m.id !=','');
        $query = $this->db->get('months m');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getClasses()
	{
		$this->db->select('c.*');
		$this->db->where('c.classid !=','');
        $query = $this->db->get('classes c');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getExamsTypes()
	{
		$this->db->select('et.*');
		$this->db->where('et.id !=','');
        $query = $this->db->get('exams_types et');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function addMonthlyfee($post)
	{
		$this->db->set($post);
        $this->db->insert('fee_structure');
        return $this->db->insert_id();
	}
	public function updateMonthlyfee($post,$id)
	{
		$this->db->where('id', $id);
        $this->db->set($post);
        $this->db->update('fee_structure');
        return $id;
	}
	public function getMonthlyfee($id='')
	{
		$this->db->select('f.*,c.class_name');
		if($id)
		{
			$this->db->where('id',$id);
		}
		$this->db->join('classes c','f.classid=c.classid');
        $query = $this->db->get('fee_structure f');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getStudents()
	{
		$this->db->select('s.GR_number');
		$this->db->order_by('s.GR_number','ASC');
        $query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getStudentsinfo()
	{
		$this->db->select('s.GR_number,c.class_name,sec.section_name,s.name');
		$this->db->join('classes c','s.classid=c.classid');
		$this->db->join('sections sec','sec.sectionid=s.sectionid');
		$this->db->order_by('s.GR_number','ASC');
        $query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getStudentinfo($id)
	{
		$this->db->select('s.name,b.branchid,b.branch_name,c.classid,c.class_name');
		$this->db->where('s.GR_number',$id);
		$this->db->join('classes c','s.classid=c.classid');
		$this->db->join('branches b','s.branchid=b.branchid','left');
        $query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return FALSE;
        }
	}
	
	public function addStudentfee($post)
	{
		$post['duedate'] = date('Y-m')."-1";
		$this->db->set($post);
        $this->db->insert('fee_history');
        return $this->db->insert_id();
	}
	public function updateStudentfee($post,$id)
	{
		$this->db->where('id', $id);
        $this->db->set($post);
        $this->db->update('fee_history');
        return $id;
	}
	public function getStudentfee($id='')
	{
		$this->db->select('h.*,c.class_name,s.name,sec.section_name,h.id as historyid,br.branch_name');
		$this->db->join('students s','s.GR_number=h.GR_number');
		$this->db->join('classes c','s.classid=c.classid');
		$this->db->join('sections sec','sec.sectionid=s.sectionid');
		$this->db->join('branches br','br.branchid=h.branchid', 'left');
		if($id)
		{
			$this->db->where('h.id',$id);
		}
        $query = $this->db->get('fee_history h');
        if ($query->num_rows() > 0) {
			if($id)
			{
				return $query->row();
			}
			else
			{
				return $query->result();
			}
            
        } else {
            return FALSE;
        }
	}
	public function pendingStudentFee($date,$gr_number)
	{
		$this->db->select('id');
		$this->db->where('GR_number',$gr_number);
		if($date)
		{
			$this->db->where('paydate',$date);
		}
		else {
			$this->db->like('paydate',date('Y-m'));
		}
		$query = $this->db->get('fee_history h');
		if ($query->num_rows() > 0) {
			return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getPreviousFee($limit,$offset)
	{
		$this->db->select('*');
		$this->db->limit($limit);
		$this->db->offset($offset);
		$query = $this->db->get('pending_fee');
		if ($query->num_rows() > 0) {
			return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getPreviousFeebyid($id)
	{
		$this->db->select('*');
		$this->db->where('id',$id);
		$query = $this->db->get('pending_fee');
		if ($query->num_rows() > 0) {
			return $query->row();
        } else {
            return FALSE;
        }
	}

	public function totalPreviousFee()
	{
		$this->db->select('*');
		$query = $this->db->get('pending_fee');
		if ($query->num_rows() > 0) {
			return $query->num_rows();
        } else {
            return FALSE;
        }
	}
	public function remove_data($id)
	{
		$this->db->where('id',$id);
		$this->db->delete('pending_fee');
	}
	public function updatePrevfee($post, $id)
	{
		$this->db->set('paid_amount',$post['paid_amount']);
		$this->db->where('id',$id);
		$this->db->update('pending_fee');
	}
	public function getAllParents()
	{
		$this->db->select('p.*');
		$this->db->order_by('p.PR_number','ASC');
        $query = $this->db->get('parents p');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function addParent($post)
	{
		$this->db->set($post);
        $this->db->insert('parents');
        return $this->db->insert_id();
	}
	public function updateParent($post,$id)
	{
		$this->db->where('ptid', $id);
        $this->db->set($post);
        $this->db->update('parents');
        return $id;
	}
	public function getParent($id='')
	{
		$this->db->select('p.*');
		if($id)
		{
			$this->db->where('p.ptid',$id);
		}
        $query = $this->db->get('parents p');
        if ($query->num_rows() > 0) {
			return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getParentByPR($PR_number='')
	{
		$this->db->select('p.*');
		if($PR_number)
		{
			$this->db->where('p.PR_number',$PR_number);
		}
        $query = $this->db->get('parents p');
        if ($query->num_rows() > 0) {
			return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getAllStudents()
	{
		$this->db->select('s.*,c.class_name,sec.section_name');
		$this->db->order_by('s.GR_number','ASC');
		$this->db->join('classes c','s.classid=c.classid','left');
		$this->db->join('sections sec','sec.sectionid=s.sectionid','left');
        $query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function addStudent($post)
	{
		$this->db->set($post);
        $this->db->insert('students');
        return $this->db->insert_id();
	}
	public function updateStudent($post,$id)
	{
		$this->db->where('stdid', $id);
        $this->db->set($post);
        $this->db->update('students');
        return $id;
	}
	public function getStudent($id='')
	{
		$this->db->select('s.*');
		if($id)
		{
			$this->db->where('s.stdid',$id);
		}
        $query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
			return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getStudentByGR($GR_number='')
	{
		$this->db->select('s.*');
		if($GR_number)
		{
			$this->db->where('s.GR_number',$GR_number);
		}
        $query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
			return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getAllBranches()
	{
		$this->db->select('b.*');
		$this->db->order_by('b.branch_name','ASC');
        $query = $this->db->get('branches b');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getAllSections()
	{
		$this->db->select('s.*');
		$this->db->order_by('s.section_name','ASC');
        $query = $this->db->get('sections s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getAllSubjects()
	{
		$this->db->select('s.*');
		$this->db->order_by('s.subject_name','ASC');
        $query = $this->db->get('subjects s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getParentStudent($PR_number)
	{
		$this->db->select('s.stdid,s.name,s.GR_number');
		if($PR_number)
		{
			$this->db->where('s.PR_number',$PR_number);
		}
		$this->db->order_by('s.GR_number','ASC');
        $query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	//public function getStudentsFees($PR_number,$GR_number='')
	public function getStudentsFees($data)
	{
		$date = $data['date'];
		$month = $data['month'];
		$PR_number = $data['PR_number'];
		$GR_number = $data['GR_number'];
		$this->db->select('fh.id,fh.GR_number,fh.type,fh.amount,fh.vat,fh.discount,fh.month,fh.paydate,fh.pay_status,s.stdid,s.name,c.classid,c.class_name,fs.amount as fees');
		//$this->db->join('classes c','s.classid=c.classid', 'left');
		$this->db->join('classes c','fh.classid=c.classid', 'left');
		$this->db->join('fee_structure fs','fh.fee_id=fs.id', 'left');
		$this->db->join('students s','fh.GR_number=s.stdid', 'left');
		//$this->db->join('pending_fee pf','s.GR_number=pf.GR_number', 'left');
		$this->db->join('pending_fee pf','fh.GR_number=pf.GR_number', 'left');
		if($month)
		{
			$this->db->where_in('fh.month',$month);
		}
		if($GR_number)
		{
			//$this->db->where_in('s.GR_number',$GR_number);
			$this->db->where_in('fh.GR_number',$GR_number);
		}
		else
		{
			$this->db->where('s.PR_number',$PR_number);
		}
		if(!empty($date) && $date!="0000-00-00")
		{
			$this->db->where('fh.paydate',date('Y-m-d',  strtotime($date)));
		}
		if(isset($data['id']) && !empty($data['id']))
		{
			$this->db->where_in('fh.id',$data['id']);
		}
		//$this->db->order_by('s.GR_number','ASC');
		$this->db->order_by('fh.id','ASC');
        //$query = $this->db->get('students s');
		$query = $this->db->get('fee_history fh');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getFeesType()
	{
		$this->db->select('*');
		$this->db->order_by('id','ASC');
        $query = $this->db->get('fees_type');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	public function getFeesValue()
	{
		$this->db->select('fv.*,c.*');
		$this->db->order_by('c.class_name','ASC');
		$this->db->join('fees_value fv','fv.classid=c.classid', 'left');
        $query = $this->db->get('classes c');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	
	public function saveFeesValue($post)
	{
		$this->db->select('*');
		$this->db->where('classid',$post['classid']);
		$query = $this->db->get('fees_value');
		$this->db->set($post);
		if ($query->num_rows() > 0) {
        	$this->db->where('classid', $post['classid']);
			$this->db->update('fees_value');
		}
		else
		{
			$this->db->insert('fees_value');
        	$this->db->insert_id();
		}
	}
	
	public function getFeesTypeByCondition($column,$value)
	{
		$this->db->select('*');
		$this->db->order_by('id','ASC');
		$this->db->where($column,$value);
        $query = $this->db->get('fees_type');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	
	public function getSetStudentFeesValueDetails($id)
	{
		$this->db->select('s.name,fv.value,c.classid,c.class_name,sc.sectionid,sc.section_name');
		$this->db->where('s.stdid',$id);
		$this->db->join('classes c','s.classid=c.classid','left');
		$this->db->join('sections sc','s.sectionid=sc.sectionid','left');
		$this->db->join('fees_value fv','fv.classid=c.classid','left');
        $query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return FALSE;
        }
	}
	
	public function setStudentFees($post)
	{
		$this->db->set($post);
		$this->db->select('*');
		$this->db->where('stdid',$post['stdid']);
		$this->db->where('fees_type_id',$post['fees_type_id']);
		$query = $this->db->get('students_fees_discounts');
		if ($query->num_rows() > 0) {
			$this->db->where('stdid',$post['stdid']);
			$this->db->where('fees_type_id',$post['fees_type_id']);
			$this->db->update('students_fees_discounts');
		}
		else
		{
			$this->db->insert('students_fees_discounts');
        	$this->db->insert_id();
		}
	}
	
	public function getStudentFees()
	{
		$this->db->select('sfd.id as sfdid,sfd.*,c.*,s.*,fv.*');
		$this->db->order_by('c.class_name','ASC');
		$this->db->join('students s','s.stdid=sfd.stdid', 'left');
		$this->db->join('classes c','c.classid=s.classid', 'left');
		$this->db->join('fees_value fv','fv.classid=c.classid', 'left');
        $query = $this->db->get('students_fees_discounts sfd');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	
	public function getStudentFeesById($id)
	{
		$this->db->select('sfd.*,c.*,s.*,fv.*');
		$this->db->join('students s','s.stdid=sfd.stdid', 'left');
		$this->db->join('classes c','c.classid=s.classid', 'left');
		$this->db->join('fees_value fv','fv.classid=c.classid', 'left');
		$this->db->where('sfd.id',$id);
        $query = $this->db->get('students_fees_discounts sfd');
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return FALSE;
        }
	}
	
	public function getStudentFeesByCondition($data)
	{
		$this->db->select('*');
		if(isset($data['id']))$this->db->where('id',$data['id']);
		if(isset($data['stdid']))$this->db->where('stdid',$data['stdid']);
		if(isset($data['fees_type_id']))$this->db->where('fees_type_id',$data['fees_type_id']);
        $query = $this->db->get('students_fees_discounts');
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return FALSE;
        }
	}
	
	public function getAddStudentFeesDetails($id)
	{
		$this->db->select('s.stdid,s.PR_number,s.name,c.classid,c.class_name,b.branchid,b.branch_name,sc.sectionid,sc.section_name,fv.value');
		$this->db->where('s.stdid',$id);
		$this->db->join('classes c','s.classid=c.classid','left');
		$this->db->join('branches b','s.branchid=b.branchid','left');
		$this->db->join('sections sc','s.sectionid=sc.sectionid','left');
		$this->db->join('fees_value fv','fv.classid=c.classid','left');
        $query = $this->db->get('students s');
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return FALSE;
        }
	}
	
	public function addStudentFees($post)
	{
		$num_rows = 0;
		$this->db->set($post);
		if(!empty($post['id']))
		{
			$this->db->select('*');
			$this->db->where('id',$post['id']);
			$query = $this->db->get('fees_payments');
			$num_rows = $query->num_rows();
		}
		//return $post;
		if ($num_rows  > 0) {
			$this->db->where('id',$post['id']);
			$this->db->update('fees_payments');
			return $post['id'];
		}
		else
		{
			$this->db->insert('fees_payments');
        	return $this->db->insert_id();
		}
	}
	
	public function getStudentPayments($post)
	{
		$this->db->select('fp.id as fpid,fp.*,c.*,s.*,sc.*,b.*,fv.*');
		//$this->db->select('fp.id as fpid,SUM(fp.pay_amount) as pay_amount,fp.*,c.*,s.*,sc.*,b.*,fv.*');
		//$this->db->group_by('fp.stdid');
		//$this->db->order_by('fp.stdid,fp.pay_date');
		$this->db->order_by('fp.pay_date','desc');
		$this->db->join('students s','s.stdid=fp.stdid', 'left');
		$this->db->join('classes c','c.classid=fp.classid', 'left');
		$this->db->join('sections sc','sc.sectionid=fp.sectionid', 'left');
		$this->db->join('branches b','b.branchid=c.branchid', 'left');
		$this->db->join('fees_value fv','fv.classid=c.classid','left');
        
		if(!empty($post['classid']))
		{
			$this->db->where('fp.classid',$post['classid']);
		}
		if(!empty($post['PR_number']))
		{
			$this->db->where('s.PR_number',$post['PR_number']);
		}
		if(!empty($post['GR_number']))
		{
			$this->db->where('s.GR_number',$post['GR_number']);
		}
		if(!empty($post['sectionid']))
		{
			$this->db->where('fp.sectionid',$post['sectionid']);
		}
		if(!empty($post['from_date']) && !empty($post['to_date']))
		{
			$this->db->where('fp.pay_date BETWEEN "'. date('Y-m-d', strtotime($post['from_date'])). '" and "'. date('Y-m-d', strtotime($post['to_date'])).'"');

		}
		$query = $this->db->get('fees_payments fp');
        if ($query->num_rows() > 0) {
            return $query->result();
        } else {
            return FALSE;
        }
	}
	
	public function getStudentPaymentsSum($stdid)
	{
		$this->db->select('SUM(pay_amount) as pay_amount');
		$this->db->group_by('stdid');
		$this->db->where('stdid',$stdid);
        $query = $this->db->get('fees_payments');
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return FALSE;
        }
	}
	
	public function getStudentPaymentsById($id)
	{
		$this->db->select('fp.id as fpid,fp.*,c.*,s.*,sc.*,b.*,fv.*,p.*');
		$this->db->join('students s','s.stdid=fp.stdid', 'left');
		$this->db->join('classes c','c.classid=fp.classid', 'left');
		$this->db->join('sections sc','sc.sectionid=fp.sectionid', 'left');
		$this->db->join('branches b','b.branchid=c.branchid', 'left');
		$this->db->join('parents p','p.PR_number=s.PR_number', 'left');
		$this->db->join('fees_value fv','fv.classid=c.classid','left');
		$this->db->where('fp.id',$id);
        $query = $this->db->get('fees_payments fp');
        if ($query->num_rows() > 0) {
            return $query->row_array();
        } else {
            return FALSE;
        }
	}
}

?>
