<?php



defined('BASEPATH') OR exit('No direct script access allowed');



class Onlinepaper_model extends CI_Model {



    public $table;



    public function __construct() {

        parent::__construct();

    }



   public function get_teacher_classes($action)
   {
	   $teacherid = $this->session->userdata['teacher_id'];
		$this->db->select("w.classid,c.class_name,w.sectionid,s.section_name,w.subjectid,sub.subject_name") ;
		$this->db->from("weekly_timetable w");
		$this->db->join("classes as c",	 "w.classid   = c.classid",'inner');
		$this->db->join("sections as s",	"w.sectionid = s.sectionid",'inner');
		$this->db->join("subjects as sub", "w.subjectid = sub.subjectid",'inner');
		
		$this->db->where("w.teacherid",$teacherid);
		
		$this->db->order_by("w.classid","ASC");
		
		if($action == "classes")
		{		
			$this->db->group_by("w.classid");
		}
		else
		{
			$this->db->group_by("w.sectionid");
		}
		return $this->db->get()->result_array();
		
		 
   }
   
   
   public function save_paper(){
	   
		$form_fields = $this->session->userdata['online_paper'];
		$teacherid = $this->session->userdata['teacher_id'];
		$data = array(
				"teacherid"  =>	$teacherid,
				"classid"    =>	$this->input->post("class_id"),
				"sectionid"  =>	$this->input->post("section_id"),
				"subjectid"  =>	$this->input->post("subject_id"),
				"type"	   =>    $this->input->post("type"),
				"pub_date"   =>	date("Y-m-d"),
				"paper"	  =>	$form_fields,
				"status"     =>	0
		);
		$this->db->insert("elearning" , $data);
		
   }
   public function edit_paper($id){
	   
		$form_fields = $this->session->userdata['online_paper'];
		$teacherid = $this->session->userdata['teacher_id'];
		$data = array(
				"teacherid"  =>	$teacherid,
				"classid"    =>	$this->input->post("class_id"),
				"sectionid"  =>	$this->input->post("section_id"),
				"subjectid"  =>	$this->input->post("subject_id"),
				"type"	   =>    $this->input->post("type"),
				"pub_date"   =>	date("Y-m-d"),
				"paper"	  =>	$form_fields,
				"status"     =>	0
		);
		$this->db->where("id",$id);
		$this->db->update("elearning" , $data);
   }
   public function get_papers($teacher = ''){
	if($teacher != "")
	{
		$this->db->where("e.teacherid",$teacher);
	}
	$this->db->select(" * , 
	(CASE status  WHEN '0' THEN 'Pending'  ELSE 'Publish'  END) as 'status',
	(CASE type  WHEN '0' THEN 'Test' WHEN '1' THEN 'Examination'  ELSE 'Behavior Management'  END) as 'type'");
	
	//$this->db->from('');
	$this->db->join('classes c ',"e.classid = c.classid",'INNER');
	$this->db->join('sections s ',"e.sectionid = s.sectionid",'INNER');
	$this->db->join('subjects sub',"e.subjectid = sub.subjectid",'INNER');
	
	if( $teacher == "" )
	{
		$this->db->join('teacher t',"e.teacherid = t.teacherid",'INNER');
	}
	$query = $this->db->get('elearning e');
	
	return $query ->result_array();
	   
	
	   
   }
   public function get_paper($paper_id = ''){
	if($paper_id != "")
	{
		$this->db->where("e.id",$paper_id);
	}
	$this->db->select("*");
	
	$this->db->from('elearning e');
	
	return $this->db->get()->row_array();
	   
	
	   
   }
   
   public function get_class_name($class)
   {
		return $this->db->where("classid",$class)->get("classes") -> row_array();
   }
   
   public function get_section_name($sectionid)
   {
		return $this->db->where("sectionid",$sectionid)->get("sections") -> row_array();
   }
   
   public function get_subject_name($subjectid)
   {
		return $this->db->where("subjectid",$subjectid)->get("subjects") -> row_array();
   }
   
}

