<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Weeklytimetable extends MY_Controller {

    public $site = 'Beladi International School | Teacher';
    public $layout = 'teacher/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('teacher_logged_in')) {
            redirect('teacher/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
		$this->load->model('teacher/wtimetable_model', 'WtimetableModel');
		
    }

    public function index() {
        $this->data['title'] = 'Timetable | Home';
		$this->data['content'] = 'wtimetable';
		$wtimetable = $this->WtimetableModel->get_wtimetable($this->session->userdata('teacher_id'));
		$timetable = "";
		if($wtimetable)
		{
			foreach ($wtimetable as $time) 
			{
				$timetable[$time->dayname] = $this->WtimetableModel->get_wtimetablebyday($time->dayid,$this->session->userdata('teacher_id'));
			}
		}
//		usort($wtimetable, 
//		 function($a, $b) { return strcmp($a->id, $b->id); });
		 //print_r($timetable);die;
		$this->data['start_time'] = $this->WtimetableModel->getallstarttime($this->session->userdata('teacher_id'));
		$this->data['periods'] = $this->WtimetableModel->getallperiods($this->session->userdata('teacher_id'));
		$this->data['wtimetable'] = $timetable;
        $this->load->view($this->layout, $this->data);
    }
	function my_sort_function($a, $b)
	{
		return strcmp($a->id, $b->id);
	}


	public function add()
	{
		$post = $_POST;
		$insert_id = $this->ComplaintsModel->add($post); 
		$this->data['title'] = 'Complaints | Home';
		$this->data['content'] = 'complaints';
		$this->data['insert']= $insert_id;
        $this->load->view($this->layout, $this->data);
	}
}