<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Teachermonth extends MY_Controller {

    public $site = 'Beladi International School | Teacher';
    public $layout = 'teacher/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('teacher_logged_in')) {
            redirect('teacher/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
//		$this->load->model('parents/appointment_model', 'AppointmentModel');
//		$this->data['confirmation_date']  = $this->AppointmentModel->get_confirmation_date($this->session->userdata['parent_id']); 
		$this->data['teacher_data'] = $this->CommonModel->get_row('teacher', $this->session->userdata('teacher_id')); 
    }

    public function index() {
        $this->data['title'] = 'Teacher of month | Home';
		$this->data['content'] = 'teachermonth';
		$this->data['teachers']  = $this->CommonModel->get_all_rows_by_branchid('teacher'); 
		
		$this->data['months']  = $this->CommonModel->get_all_rows('months'); 
		$this->data['mteacher']  = $this->CommonModel->getRowsusermonths('teacher',$this->data['teacher_data']->branchid);
        $this->load->view($this->layout, $this->data);
    }
}