<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Progress extends MY_Controller {

    public $site = 'Beladi International School | Teacher';
    public $layout = 'teacher/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('teacher_logged_in')) {
            redirect('teacher/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('teacher/progress_model', 'ProgressModel');
        // Get Logged Teacher
        $this->data['teacher_data'] = $this->CommonModel->get_row('teacher', $this->session->userdata('teacher_id'));
    }

    public function index() 
	{
		if($_POST)
		{
			$this->ProgressModel->add($_POST);
			$this->data['insert'] = 'yes';
		}
		$this->data['students'] = $this->ProgressModel->getStudent($this->data['teacher_data']->classid,$this->data['teacher_data']->sectionid);
		$this->data['reports'] = $this->ProgressModel->getStudentreport($this->data['teacher_data']->classid,$this->data['teacher_data']->sectionid);
		$this->data['content'] = 'progress';
        $this->load->view($this->layout, $this->data);
    }
	public function edit($id) 
	{
		if($_POST)
		{
			$this->ProgressModel->update($_POST,$id);
			$this->data['insert'] = 'yes';
		}
		$this->data['students'] = $this->ProgressModel->getStudent($this->data['teacher_data']->classid,$this->data['teacher_data']->sectionid);
		$this->data['report'] = $this->ProgressModel->getReport($id);
		$this->data['id'] = $id;
		$this->data['content'] = 'progress_edit';
        $this->load->view($this->layout, $this->data);
	}
}