<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Marksheet extends MY_Controller {

    public $site = 'Beladi International School | Teacher';
    public $layout = 'teacher/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('teacher_logged_in')) {
            redirect('teacher/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('teacher/MarkSheet_model', 'MarkSheetModel');
		$this->data['teacher_data'] = $this->CommonModel->get_row('teacher', $this->session->userdata('teacher_id')); 
    }

    public function index() {
        $this->data['title'] = 'Mark Sheet | Home';
		$this->data['content'] = 'mark_sheet';
		/*if($_POST)
		{
			foreach($_POST['mark_id'] as $key=>$makr_id)
			{
				$data = array();
				$data['year'] = $_POST['year'];
				$data['exam'] = $_POST['exam'];
				$data['month'] = $_POST['month'];
				$data['class'] = $_POST['class'];
				$data['subject'] = $_POST['subject'];
				$data['section'] = $_POST['section'];
				$data['student'] = $_POST['student'][$key];
				$data['total_marks'] = $_POST['total_marks'];
				$data['questions_marks'] = $_POST['questions_marks'][$key];
				$data['class_work_marks'] = $_POST['class_work_marks'][$key];
				$exists = $this->MarkSheetModel->get_student_marks_by_id($makr_id);
				if(!$exists)
				{
					$this->MarkSheetModel->add_student_marks($data); 
				}
				else
				{
					$this->MarkSheetModel->update_student_marks($data,$makr_id); 
				}
			}
			redirect('teacher/marksheet');
		}*/
		$this->data['months'] = $this->CommonModel->get_all_rows("months");
		$this->data['classes'] = $this->CommonModel->get_all_rows("classes");
		$this->data['subjects'] = $this->CommonModel->get_all_rows("subjects");
		$this->data['sections'] = $this->CommonModel->get_all_rows("sections");
		$this->data['exams'] = $this->CommonModel->get_all_rows("exams_types");
		$this->data['message'] = $this->session->flashdata('message');
        $this->load->view($this->layout, $this->data);
    }
	
	public function getStudentMarks()
	{
		$students = array();
		if(!empty($_POST))
		{
			$_POST['teacherid'] = $this->data['teacher_data']->teacherid;
			$students = $this->MarkSheetModel->get_student_marks($_POST);
		} 
		//echo "<pre>";print_r($students);
		echo json_encode($students);
	}
	
	public function save()
	{
		if($_POST)
		{
			foreach($_POST['mark_id'] as $key=>$makr_id)
			{
				$data = array();
				$data['year'] = $_POST['year'];
				$data['exam'] = $_POST['exam'];
				$data['month'] = $_POST['month'];
				$data['class'] = $_POST['class'];
				$data['subject'] = $_POST['subject'];
				$data['section'] = $_POST['section'];
				$data['teacher'] = $_POST['teacher'];
				$data['student'] = $_POST['student'][$key];
				$exam_term = !empty($_POST['exam_term'])?$_POST['exam_term'][$key]."_term_":"first_term_";
				if(!empty($_POST['max_marks']))$data[$exam_term.'max_marks'] = $_POST['max_marks'];
				//if(!empty($_POST['total_marks']))$data[$exam_term.'total_marks'] = $_POST['total_marks'];
				if(!empty($_POST['exam_marks']))$data[$exam_term.'exam_marks'] = $_POST['exam_marks'][$key];
				if(!empty($_POST['exam_max_marks']))$data[$exam_term.'exam_max_marks'] = $_POST['exam_max_marks'];
				if(!empty($_POST['exam_passing_marks']))$data[$exam_term.'exam_passing_marks'] = $_POST['exam_passing_marks'];
				if(!empty($_POST['questions_marks']))$data[$exam_term.'questions_marks'] = $_POST['questions_marks'][$key];
				if(!empty($_POST['questions_max_marks']))$data[$exam_term.'questions_max_marks'] = $_POST['questions_max_marks'];
				if(!empty($_POST['questions_passing_marks']))$data[$exam_term.'questions_passing_marks'] = $_POST['questions_passing_marks'];
				if(!empty($_POST['class_work_marks']))$data[$exam_term.'class_work_marks'] = $_POST['class_work_marks'][$key];
				if(!empty($_POST['class_work_max_marks']))$data[$exam_term.'class_work_max_marks'] = $_POST['class_work_max_marks'];
				if(!empty($_POST['class_work_passing_marks']))$data[$exam_term.'class_work_passing_marks'] = $_POST['class_work_passing_marks'];
				$exists = $this->MarkSheetModel->get_student_marks_by_id($makr_id);//echo "<pre>";print_r($data);
				//$exists = $this->MarkSheetModel->get_student_marks_by_id($data);
				if(!$exists)
				{
					$this->MarkSheetModel->add_student_marks($data); 
				}
				else
				{
					$this->MarkSheetModel->update_student_marks($data,$makr_id); 
				}
			}
			$this->session->set_flashdata('message', 'submitted');
			redirect('teacher/marksheet',$this->data);
		}
	}
}