<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Lesson extends MY_Controller {

    public $site = 'Beladi International School | Teacher';
    public $layout = 'teacher/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('teacher_logged_in')) {
            redirect('teacher/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('teacher/lesson_model', 'LessonsModel');
//		$this->data['branches'] = $this->CommonModel->get_all_rows('branches');
//		$this->data['classes']  = $this->CommonModel->get_all_rows('classes');
//		$this->data['sections'] = $this->CommonModel->get_all_rows('sections');
//		$this->data['subjects'] = $this->CommonModel->get_all_rows('subjects');
		
    }

    public function index() {
        $this->data['title'] = 'Lesson Plan | Home';
		$this->data['content']  = 'lesson';
		$this->data['lessons'] = $this->LessonsModel->get_lesson_plan($this->session->userdata('teacher_id'));
        $this->load->view($this->layout, $this->data);
    }
	public function add()
	{
		$post = $_POST;
		$post['datetime'] = date('Y-m-d',strtotime($post['datetime']));
		$insert_id = $this->LessonsModel->add($post); 
		$this->data['title'] = 'Lesson | Home';
		$this->data['content'] = 'lesson';
		$this->data['insert']= $insert_id;
		$this->data['lessons'] = $this->LessonsModel->get_lesson_plan($this->session->userdata('teacher_id'));
        $this->load->view($this->layout, $this->data);
	}
}