<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Homework extends MY_Controller {

    public $site = 'Beladi International School | Teacher';
    public $layout = 'teacher/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('teacher_logged_in')) {
            redirect('teacher/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('teacher/homework_model', 'HomeworkModel');
		// Get Logged User
        //$this->data['teacher_data'] = $this->CommonModel->get_row('teacher', $this->session->userdata('teacher_id')); 
		$this->data['classes']  = $this->CommonModel->get_all_rows('classes');
		$this->data['sections'] = $this->CommonModel->get_all_rows('sections');
		$this->data['subjects'] = $this->CommonModel->get_all_rows('subjects');
    }

    public function index() {
        $this->data['title'] = 'Homework | Home';
		$this->data['content'] = 'homework';
		$this->data['homework'] = $this->HomeworkModel->get_homework($this->session->userdata('teacher_id'));
        $this->load->view($this->layout, $this->data);
    }
	public function add()
	{
		$image_name='';
		$img_path = "assets/homework";
		if (isset($_FILES['image']['error']) && $_FILES['image']['error'] != 4) {
			$img_path = "assets/homework";
			$image_name = time() . "_" . $_FILES['image']['name'];
			$image_name = $this->do_upload($img_path, $image_name);
		}
		if (isset($_FILES['document']['error']) && $_FILES['document']['error'] != 4) {
			
			$document_name = time() . "_" . $_FILES['document']['name'];
			$doc_name = $this->do_upload($img_path, $document_name);
		}
		$document = $_FILES;
		$doc_name = $this->do_uploadfile($document);
		$post = $_POST;
		$post['images'] = $image_name;
		$post['document'] = $doc_name;
		$post['date'] = date('Y-m-d',strtotime($post['date']));
		$insert_id = $this->HomeworkModel->add($post); 
		$this->data['title'] = 'Exams | Home';
		$this->data['content'] = 'homework';
		$this->data['insert']= $insert_id;
		$this->data['homework'] = $this->HomeworkModel->get_homework($this->session->userdata('teacher_id'));
        $this->load->view($this->layout, $this->data);
	}
	function delete_homework()
	{
		$this->HomeworkModel->deletehomework($_POST['id']); 
	}
	
}