<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Grading extends MY_Controller {

    public $site = 'Al Hukama International School | Parents';
    public $layout = 'teacher/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('teacher_logged_in')) {
            redirect('teacher/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('Onlinepaper_model',"emodel");
		$this->load->model('teacher/grading_model', 'grade');
        // Get Logged Teacher
        $this->data['teacher_data'] = $this->CommonModel->get_row('teacher', $this->session->userdata('teacher_id'));
    }
	
  public function mange_marks()
  {
	$this->data['title'] = 'Papers';
    $this->data['content'] = 'mange_marks';
	$this->data['form_data'] = $this->grade->get_class_section_info($this->data['teacher_data']->branchid , $this->session->userdata('teacher_id'));
		
	$this->load->view($this->layout, $this->data);  
  }	
	
  public function mange_marks_add($classid , $sectionid)
  {
	$this->data['title'] = 'Papers';
    $this->data['content'] = 'mange_add_marks';
	$this->data['form_data'] = $this->grade->get_subject_class($classid , $this->data['teacher_data']->branchid);
	
	$this->data['sectionid'] = $sectionid;	
	$this->load->view($this->layout, $this->data);  
  }
  
  public function add_marks($class_id , $section_id , $subject_id,$term_id=0,$month_id = 0)
  {
	$this->data['title'] = 'Papers';
    $this->data['content'] = 'add_marks';
	
	if($this->input->post("add_marks_setting"))
	{
	  $this->grade->add_marks_setting($class_id , $section_id , $subject_id , $this->data['teacher_data']->branchid);	
	}
	if($this->input->post("add_marks"))
	{
	  $this->grade->add_marks($class_id , $section_id , $subject_id , $this->data['teacher_data']->branchid,$term_id,$month_id);	
	}
	
	$this->data['student'] = $this->grade->get_student($class_id , $section_id , $this->data['teacher_data']->branchid);
	
	$this->data['class'] = $this->grade->get_class_info($class_id);
	$this->data['subject'] = $this->grade->get_subject_info($subject_id);
	$this->data['section'] = $this->grade->get_section_info($section_id);
	
	if($term_id > 0 && $month_id > 0)
	{ 
	
	$this->data['marks'] = $this->grade->get_marks($class_id , $section_id , $subject_id , 	$this->data['teacher_data']->branchid,$term_id,$month_id);
	$this->data['marks_setting'] = $this->grade->get_marks_setting($class_id , $section_id , $subject_id , $this->data['teacher_data']->branchid,$term_id,$month_id);
	
	}
	
	$this->data['term_id'] = $term_id;
	$this->data['month_id'] = $month_id;
	$this->data['class_id'] = $class_id;
	$this->data['section_id'] = $section_id;
	$this->data['subject_id'] = $subject_id;
	$this->data['branch_id'] = $this->data['teacher_data']->branchid;
		
	$this->load->view($this->layout, $this->data);  
  }	
	
}