<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Elearning extends MY_Controller {

    public $site = 'Al Hukama International School | Parents';
    public $layout = 'teacher/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('teacher_logged_in')) {
            redirect('teacher/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('Onlinepaper_model',"emodel");
        // Get Logged Teacher
        $this->data['teacher_data'] = $this->CommonModel->get_row('teacher', $this->session->userdata('teacher_id'));
    }

    public function index() {
        $this->data['title'] = 'Papers';
		$this->data['content'] = 'el_list_paper';
		$teacherid = $this->session->userdata['teacher_id'];
		
		$this->data["papers"] = $this->emodel->get_papers($teacherid);
		$this->load->view($this->layout, $this->data);
    }
	
	public function view_result($paper_id , $classid , $sectionid)
	{
	    $this->data['title'] = 'Papers';
		$this->data['content'] = 'el_view_result';
		$teacherid = $this->session->userdata['teacher_id'];
		
		$this->data["student"] = $this->emodel->get_students($classid , $sectionid);
		
        $this->load->view($this->layout, $this->data);	
	}
	
	public function check_paper($paper_id , $stdid)
	{
	    $this->data['title'] = 'Papers';
		$this->data['content'] = 'el_check_paper';
		$teacherid = $this->session->userdata['teacher_id'];
		
		$this->data["paper"] = $this->emodel->get_paper($paper_id);
		$this->data["answer"] = $this->emodel->get_answer($paper_id , $stdid);
		$this->load->view($this->layout, $this->data);	
	}
	
	public function create()
	{
		if($this->input->post())
		{
			$class   = $this->input->post("class");
			$section = $this->input->post("section");
			$subject = $this->input->post("subject");
			$type = $this->input->post("type");

			redirect(base_url("teacher/elearning/create_paper/$class/$section/$subject/$type"));
		}
		$teacherid = $this->session->userdata['teacher_id'];
		$this->data['title'] = 'Create Paper';
		$this->data['content'] = 'el_create_paper_step1';
		$this->data["get_teacher_classes"] = $this->emodel->get_teacher_classes('classes');
		$this->data["get_teacher_section"] = $this->emodel->get_teacher_classes('sections');
		
        $this->load->view($this->layout, $this->data);
	}
	public function create_paper($class,$section,$subject,$type=0)
	{
		
		$this->data["class_name"]   = $this->emodel->get_class_name($class);
		$this->data["class_id"]   	 = $class;
		$this->data["section_name"] = $this->emodel->get_section_name($section);
		$this->data["section_id"]   = $section;
		$this->data["subject_name"] = $this->emodel->get_subject_name($subject);
		$this->data["subject_id"]   = $subject;
		$this->data["type"]         = $type;
		
		
		$this->data['title'] = 'Create Paper';
		$this->data['content'] = 'el_create_paper';
		$teacherid = $this->session->userdata['teacher_id'];
		
        $this->load->view($this->layout, $this->data);
	}
	public function save_paper($action = '',$id=''){
		
		if($action == '')
		{
			$form_data = json_decode(file_get_contents('php://input'));
			foreach ($form_data as $key => $value) {
				$field[$value->name] = $value->value;
			}
			$formID = $field['formID'];
			$formFields = json_encode($field['formFields']);
			
			$this->session->set_userdata('online_paper', $formFields);
		}
		if($action == "edit"){
			
			$this->emodel->edit_paper($id);
			redirect(base_url("teacher/elearning"));
		}
		else
		{
			
			$this->emodel->save_paper();
			redirect(base_url("teacher/elearning"));
		}
		
	}
	
	public function load_paper($id ="")
	{
		if($id == '')
		{
			if(isset($this->session->userdata['online_paper']))
			{
				echo $this->session->userdata['online_paper'];	
			}
		}
		else
		{
				$paper_detail = $this->emodel->get_paper($id);
				echo $paper_detail["paper"];
				$this->session->set_userdata('online_paper', $paper_detail["paper"]);
		}
	}
	public function view_paper($class,$section,$subject,$type=0)
	{
		
		$this->data["class_id"]   	 = $class;
		$this->data["section_id"]   = $section;
		$this->data["subject_id"]   = $subject;
		$this->data["type"]         = $type;

		
		$this->data['title'] = 'View Paper';
		$this->data['content'] = 'el_view_paper';
		$teacherid = $this->session->userdata['teacher_id'];
		
        $this->load->view($this->layout, $this->data);
		
	}
	
	
	
	public function edit($id)
	{
		$paper_detail = $this->emodel->get_paper($id);
		$this->data['paper_detail'] = $paper_detail;
		$teacherid = $this->session->userdata['teacher_id'];
		
		if($paper_detail["teacherid"] != $teacherid)
		{
			die('No access');	
		}
		if($this->input->post())
		{
			$class   = $this->input->post("class");
			$section = $this->input->post("section");
			$subject = $this->input->post("subject");
			$type = $this->input->post("type");

			redirect(base_url("teacher/elearning/edit_paper/$class/$section/$subject/$type/$id"));
		}
		$teacherid = $this->session->userdata['teacher_id'];
		$this->data['title'] = 'Edit Paper';
		$this->data['content'] = 'el_edit_paper_step1';
		$this->data["get_teacher_classes"] = $this->emodel->get_teacher_classes('classes');
		$this->data["get_teacher_section"] = $this->emodel->get_teacher_classes('sections');
		
		
        $this->load->view($this->layout, $this->data);
	}
	
	public function edit_paper($class,$section,$subject,$type=0,$id)
	{
		$this->data["id"] = $id;
		$paper_detail = $this->emodel->get_paper($id);
		$this->data['paper_detail'] = $paper_detail;
		$teacherid = $this->session->userdata['teacher_id'];
		
		if($paper_detail["teacherid"] != $teacherid)
		{
			die('No access');	
		}
		
				$this->data["class_name"]   = $this->emodel->get_class_name($class);
		$this->data["class_id"]   	 = $class;
		$this->data["section_name"] = $this->emodel->get_section_name($section);
		$this->data["section_id"]   = $section;
		$this->data["subject_name"] = $this->emodel->get_subject_name($subject);
		$this->data["subject_id"]   = $subject;
		$this->data["type"]         = $type;

		
		
		$this->data['title'] = 'Edit Paper';
		$this->data['content'] = 'el_edit_paper';
		$teacherid = $this->session->userdata['teacher_id'];
		
        $this->load->view($this->layout, $this->data);
	}
	public function edit_view_paper($class,$section,$subject,$type=0,$id)
	{
		
		$this->data["id"]   	 = $id;
		$this->data["class_id"]   	 = $class;
		$this->data["section_id"]   = $section;
		$this->data["subject_id"]   = $subject;
		$this->data["type"]         = $type;

		
		$this->data['title'] = 'View Paper';
		$this->data['content'] = 'el_edit_view_paper';
		$teacherid = $this->session->userdata['teacher_id'];
		
        $this->load->view($this->layout, $this->data);
		
	}
	public function delete($id)
	{
		$paper_detail = $this->emodel->get_paper($id);
		$teacherid = $this->session->userdata['teacher_id'];
		if($paper_detail["teacherid"] != $teacherid)
		{
			die('No access');	
		}
		$this->db->where("id",$id);
		$this->db->delete("elearning");
		redirect(base_url("teacher/elearning"));
		

	}
	
}