<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Documents extends MY_Controller {

    public $site = 'Beladi International School | Parents';
    public $layout = 'teacher/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('teacher_logged_in')) {
            redirect('teacher/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('teacher/Documents_model', 'DocumentsModel');
		// Get Logged User
        $this->data['teacher_data'] = $this->CommonModel->get_row('teacher', $this->session->userdata('teacher_id')); 
    }

    public function index() {
        $this->data['title'] = 'Documents | Home';
		$this->data['content'] = 'documents';
		$this->load->model('teacher/teacher_model', 'TeacherModel');
        $this->load->view($this->layout, $this->data);
    }
}