<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class StdAbsents extends MY_Controller {

    public $site = 'Beladi International School | Attendance';
    public $layout = 'principle/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('principle_logged_in')) {
            redirect('principle/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('principle/StdAbsents_model', 'stdAbsentsModel');
		// Get Logged User
        $this->data['principle_data'] = $this->CommonModel->get_row('principle', $this->session->userdata('principle_id')); 
    }

    public function index() {
		$this->data['date'] = date('Y-m-d'); 
		$date = "";
		$classid = "";
		$sectionid = "";
		$this->data['classid'] = "";
		$this->data['sectionid'] = "";
		
		if(isset($_POST['date']) && $_POST['date'] != "")
		{
			$date = date('Y-m-d',  strtotime($_POST['date']));
			$this->data['date'] = $date;
		}
		if(isset($_POST['classid']) && $_POST['classid'] != "")
		{
			$classid = $_POST['classid'];
			$this->data['classid'] = $classid;
		}
		if(isset($_POST['sectionid']) && $_POST['sectionid'] != "")
		{
			$sectionid = $_POST['sectionid'];
			$this->data['sectionid'] = $sectionid;
		}
        $this->data['students'] = $this->stdAbsentsModel->getstdAbsents($date,$classid,$sectionid);
		$this->data['content']  = 'sabsents_listing';
		$this->data['classes']  = $this->CommonModel->get_all_rows('classes'); 
		$this->data['sections']  = $this->CommonModel->get_all_rows('sections'); 
		$this->load->view($this->layout, $this->data);
    }
	
	public function print_sabsents($date='')
	{
		$this->data['students'] = $this->stdAbsentsModel->getstdAbsents($date,'','');
		$this->load->library('mpdf/mpdf');
		
		$html = $this->load->view('principle/sabsents_print', $this->data, true);
		$mpdf = new mPDF('ar-s', 'A4', '', 'Arial', 16, 16, 12, 12, 9, 9);
		// $html = iconv("windows-1256","UTF-8//IGNORE",$html);
		$mpdf->SetDisplayMode('fullpage');
		$mpdf->list_indent_first_level = 0; // 1 or 0 - whether to indent the first level of a list
		// LOAD a stylesheet
		$stylesheet = file_get_contents('./assets/css/pdf.css');
		$mpdf->WriteHTML($stylesheet, 1);    // The parameter 1 tells that this is css/style only and no body/html/text
		//$mpdf->SetHTMLFooter($footer);
		$mpdf->SetFooter($this->data['settings']->site_name . '|{PAGENO}|' . date(DATE_RFC822));
		$mpdf->WriteHTML($html, 2);

		$file_name = date('Y_m_d_His') . '_fee_list.pdf';
		$mpdf->Output($file_name, 'I'); // F = Move to Directory, I = View, D = Download  
        $this->load->view($this->layout, $this->data);
	}
	
	
}