<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Appointment extends MY_Controller {

    public $site = 'Beladi International School | Principle';
    public $layout = 'principle/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('principle_logged_in')) {
            redirect('principle/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('principle/appointment_model', 'AppointmentModel');
		$this->data['parents']  = $this->CommonModel->get_all_rows_by_branchid('parents'); 
		// Get Logged User
        $this->data['principle_data'] = $this->CommonModel->get_row('principle', $this->session->userdata('principle_id')); 
    }

    public function index() {
        $this->data['title'] = 'Appointment | Home';
		$this->data['content'] = 'appointment';
		$this->data['appointments']  = $this->AppointmentModel->get_appointments(); 
        $this->load->view($this->layout, $this->data);
    }
	public function add()
	{
		$post = $_POST;
		$post['type'] = 'receive';
		$post['appointment_date'] = date('Y-m-d h:m:s',  strtotime($_POST['appointment_date']));
		$insert_id = $this->AppointmentModel->add($post); 
		$this->data['title'] = 'Appointment | Home';
		$this->data['content'] = 'appointment';
		$this->data['insert']= $insert_id;
		$this->data['appointments']  = $this->AppointmentModel->get_appointments();
        $this->load->view($this->layout, $this->data);
	}
	public function edit($id)
	{
		if($_POST)
		{
			if($_POST['type'] == 'receive')
			{
				$_POST['appointment_date'] = date('Y-m-d h:m:s',  strtotime($_POST['appointment_date']));
				unset($_POST['confirmation_date']);
			}
			else
			{
				$_POST['confirmation_date'] = date('Y-m-d h:m:s',  strtotime($_POST['appointment_date']));
				unset($_POST['appointment_date']);
			}
			$this->AppointmentModel->update($_POST,$id);
			$this->data['insert'] = 'yes';
			redirect("principle/appointment");
		}
		$this->data['appointment']  = $this->AppointmentModel->get_appointmentbyid($id);
		$this->data['title'] = 'Appointment | Home';
		$this->data['content'] = 'appointment_edit';
		$this->data['appointments']  = $this->AppointmentModel->get_appointments();
        $this->load->view($this->layout, $this->data);
	}
}