<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Teachermonth extends MY_Controller {

    public $site = 'Beladi International School | Principal';
    public $layout = 'principal/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('principal_logged_in')) {
            redirect('principal/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->data['principal_data'] = $this->CommonModel->get_row('principal', $this->session->userdata('principal_id')); 
//		$this->load->model('parents/appointment_model', 'AppointmentModel');
//		$this->data['confirmation_date']  = $this->AppointmentModel->get_confirmation_date($this->session->userdata['parent_id']); 
    }

    public function index() {
        $this->data['title'] = 'Teacher of month | Home';
		$this->data['content'] = 'teachermonth';
		if($_POST)
		{
			$post = $_POST;
			$post['type'] =	'teacher';
			$post['branchid'] = $this->session->userdata('principal_branchid');
			$this->data['insert'] = 'yes';
			//$this->CommonModel->user_delete('userofmonth',$post['month'],'teacher'); 
			
			$this->CommonModel->insert('userofmonth',$post); 
		}
		$this->data['teachers']  = $this->CommonModel->get_all_rows_by_branchid('teacher'); 
		
		$this->data['months']  = $this->CommonModel->get_all_rows('months'); 
		$this->data['mteacher']  = $this->CommonModel->getRowsusermonths('teacher',$this->session->userdata('principal_branchid'));
        $this->load->view($this->layout, $this->data);
    }
	public function delete($id)
	{
		$this->CommonModel->delete($id); 
		redirect(base_url()."principal/Teachermonth");
	}
	public function edit($id)
	{
		$this->data['content'] = 'teachermonth_edit';
		if($_POST)
		{
			$post['month'] = $this->input->post('month');
			$post['userid'] = $this->input->post('userid');
			$post['details'] = $this->input->post('details');
			$this->data['insert'] = 'yes';
			$this->CommonModel->update('userofmonth', $id, $post); 
		}
		$this->data['teachers']  = $this->CommonModel->get_all_rows_by_branchid('teacher'); 
		
		$this->data['months']  = $this->CommonModel->get_all_rows('months'); 
		$this->data['teacher'] = $this->CommonModel->get_userofmonth($id); 
		$this->load->view($this->layout, $this->data);
	}
}