<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Importdata extends MY_Controller {

    public $site = 'Beladi International School | Principal';
    public $layout = 'principal/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('principal_logged_in')) {
            redirect('principal/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
		$this->load->model('common_model', 'CommonModel');
		$this->load->model('principal/Importdata_model', 'ImportdataModel');
		$this->load->library('excel');
		$this->data['principal_data'] = $this->CommonModel->get_row('principal', $this->session->userdata('principal_id')); 
    }

    public function index() 
	{
		ini_set('max_execution_time', 1000);
		if($_FILES)
		{
			if($_FILES["filename"]["size"] > 0)
			{
				$table = $_POST['table'];
				$filename=$_FILES["filename"]["tmp_name"];
				//load our new PHPExcel library

				$objPHPExcel = PHPExcel_IOFactory::load($filename);

				//get only the Cell Collection
				$cell_collection = $objPHPExcel->getActiveSheet()->getCellCollection();
				//extract to a PHP readable array format
				$count = 0;
				$header = array();
				$sheetData = $objPHPExcel->getActiveSheet()->toArray(null,true,true,true);
				foreach($sheetData as $key=> $rec)
				{
					if($count != 0)
					{
						if($table == 'parents')
						{
							$insert_data ['PR_number'] = $rec['A'];
							$insert_data ['username'] = $rec['B'];
							$insert_data ['parent_password'] = $rec['C'];
							$insert_data ['father_name'] = $rec['D'];
							$this->CommonModel->insert('parents',$insert_data);		
						}
						else if($table == 'students')
						{
							$insert_data ['branchid'] = $rec['A'];
							$insert_data ['name'] = $rec['B'];
							if($insert_data ['branchid'] == 1)
							{
								$insert_data ['gender'] = 'female';
							}
							else
							{
								$insert_data ['gender'] = 'male';
							}
							if($rec['D'])
							{
								$classid = $this->ImportdataModel->getclassname($rec['D']);	
								if($classid)
								{
									$insert_data ['classid'] = $classid->classid;
								}
							}
							else
							{
								$insert_data ['classid']  = 0;
							}
							if($rec['E'])
							{
								$sectionid = $this->ImportdataModel->getsectionname($rec['E']);		
								if($sectionid){
									$insert_data ['sectionid'] = $sectionid->sectionid;
								}
								
							}
							else{
								$insert_data ['sectionid'] = 0;
							}
							$insert_data ['PR_number'] = $rec['G'];
							$insert_data['GR_number'] = $rec['F'];
							$insert_data ['nationality'] = $rec['H'];
							$insert_data['religion'] = $rec['I'];
							
							$insert_data['dob'] = date('Y-m-d',  strtotime($rec['J']));
							$insert_data['iqama_no'] = $rec['K'];
							//$insert_data['iqama_expiry'] =  $rec['L'];
							$insert_data['parent_iqama'] = $rec['M'];
							//$insert_data['parent_iqama_expiry'] =  $rec['N'];
							$this->CommonModel->insert('students',$insert_data);		
							
						}
						else if($table == "weekly_timetable")
						{
							$this->import_timetable($rec);
						}
					}
					$count++;
				}
				$this->data['insert'] = 'yes';
			}
		}
        $this->data['title'] = 'Importdata | Home';
		$this->data['content'] = 'import_data';
        $this->load->view($this->layout, $this->data);
    }
	public function import_timetable($rec)
	{
		if($rec['D'])
		{
			$classid = $this->ImportdataModel->getclassname($rec['D']);	
			if($classid)
			{
				$insert_data ['classid'] = $classid->classid;
			}
		}
		else
		{
			$insert_data ['classid']  = 0;
		}
		if($rec['C'])
		{
			$sectionid = $this->ImportdataModel->getsectionname($rec['C']);		
			if($sectionid){
				$insert_data ['sectionid'] = $sectionid->sectionid;
			}

		}
		else{
			$insert_data ['sectionid'] = 0;
		}
		if($rec['B'])
		{
			$subjectid = $this->ImportdataModel->getsubjectname($rec['B']);		
			if($subjectid){
				$insert_data ['subjectid'] = $subjectid->subjectid;
			}

		}
		else{
			$insert_data ['subjectid'] = 0;
		}
		
		if($rec['G'])
		{
			$month = $this->ImportdataModel->getmonthname($rec['G']);		
			if($month){
				$insert_data ['dayid'] = $month->id;
			}

		}
		else{
			$insert_data ['dayid'] = 0;
		}
		if($rec['H'])
		{
			$teacher = $this->ImportdataModel->getteachername($rec['H']);		
			if($teacher){
				$insert_data['teacherid'] = $teacher->teacherid;
			}
			else{
				$insert_data ['teacherid'] = 0;
			}

		}
		else{
			$insert_data ['teacherid'] = 0;
		}
		$insert_data['period_no'] = $rec['A'];
		if($insert_data['classid'] == 0 && $insert_data['sectionid'] == 0 && $insert_data['subjectid'] == 0)
		{
			$insert_data['free'] = 'Y';
		}
		else 
		{
			$insert_data['free'] = 'N';
		}
		print_R($insert_data);
		$insert = $this->CommonModel->insert('weekly_timetable',$insert_data);
		//var_dump($insert);die;
		
		
	}
}