<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Elearning extends MY_Controller {

    public $site = 'Al Hukama International School | Parents';
    public $layout = 'principal/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('principal_logged_in')) {
            redirect('principal/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('Onlinepaper_model',"emodel");
        // Get Logged Teacher
        $this->data['principal_data'] = $this->CommonModel->get_row('principal', $this->session->userdata('principal_id')); 
    }

    public function index() {
        $this->data['title'] = 'Papers';
		$this->data['content'] = 'el_list_paper';
		
		$this->data["papers"] = $this->emodel->get_papers();
		$this->load->view($this->layout, $this->data);
    }
	
	public function view_result($paper_id , $classid , $sectionid)
	{
	    $this->data['title'] = 'Papers';
		$this->data['content'] = 'el_view_result';
		
		
		$this->data["student"] = $this->emodel->get_students($classid , $sectionid);
		
        $this->load->view($this->layout, $this->data);	
	}
	
	public function check_paper($paper_id , $stdid)
	{
	    $this->data['title'] = 'Papers';
		$this->data['content'] = 'el_check_paper';
		
		
		$this->data["paper"] = $this->emodel->get_paper($paper_id);
		$this->data["answer"] = $this->emodel->get_answer($paper_id , $stdid);
		$this->load->view($this->layout, $this->data);	
	}
	
	public function update_status($id,$action)
	{
	
		$this->db->where("id",$id);
		$this->db->update("elearning",array("status"=>$action));
		redirect(base_url("principal/elearning"));
		
	}
	public function delete($id)
	{
		
		$this->db->where("id",$id);
		$this->db->delete("elearning");
		redirect(base_url("principal/elearning"));
		

	}
	
}