<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Auth extends MY_Controller {

    public $site = 'Beladi International School | Principal';
    public $layout = 'admin/common/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();        
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        $this->data['content'] = '';
        $this->data['msg'] = '';
        $this->load->model('principal/auth_model', 'AuthModel');
    }
    public function index() {
        $this->data['title'] = $this->site;
        $this->load->view('principal/login', $this->data);
    }

    public function login() {
            $username = $this->input->post('username');
            $password = $this->input->post('password');
            $user = $this->AuthModel->login($username, $password);
            if ($user) {
                 $this->register_session($user);
            } else {
                $this->data['msg'] = '<p class="error">ERROR: Login failed.</p>';
                $this->load->view('principal/login',  $this->data);
            }
    }


    public function register_session($principal) {
        $this->session->set_userdata('principal_id', $principal->id);
		$this->session->set_userdata('principal_branchid', $principal->branchid);
        $this->session->set_userdata('principal_logged_in', TRUE);  
        redirect('principal/profile/dashboard');
    }
   
    public function logout() {
        $this->session->unset_userdata('principal_logged_in');
        $this->session->unset_userdata('principal_id');
		$this->session->unset_userdata('principal_branchid');
		
        $this->session->sess_destroy();

        redirect('principal/auth');
    }
    

    function createRandomPassword() {
        $chars = "abcdefghiHKJHIUHIUHKJNKNKJjkmnopqrstuvwxyz023456789";
        srand((double) microtime() * 1000000);
        $i = 0;
        $pass = '';
        while ($i <= 7) {
            $num = rand() % 33;
            $tmp = substr($chars, $num, 1);
            $pass = $pass . $tmp;
            $i++;
        }

        return $pass;
    }
}