<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Fee extends MY_Controller {

    public $site = 'Beladi International School | Parents';
    public $layout = 'parents/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('parent_logged_in')) {
            redirect('parents/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('parents/fee_model', 'FeeModel');
		$this->load->model('parents/parent_model', 'ParentModel');
		// Get Logged User
        $this->data['parent_data'] = $this->CommonModel->get_row('parents', $this->session->userdata('parent_id')); 
    }

    public function index() {
        $this->data['title'] = 'Fee Alerts | Home';
		$this->data['content'] = 'fee';
		$students = $this->ParentModel->getStudent($this->data['parent_data']->PR_number);
		$fee_history = "";
		$fee_alert = "";
		if($students)
		{
			foreach ($students as $std) 
			{
				$fee_history[$std->stdid] = $this->CommonModel->search_row('fee_history',$std->GR_number);
				$fee_alert[$std->stdid] = $this->FeeModel->fee_alert($std->GR_number);
			}
		}
		$d = new DateTime("now");
		$d->modify( 'first day of next month' );
		$this->data['next_month'] = $d->format( 'M' )." ".$d->format( 'Y' );
		$this->data['fee_history'] = $fee_history;
		$this->data['fee_alerts'] = $fee_alert;
		$this->data['students'] = $students;
        $this->load->view($this->layout, $this->data);
    }
}