<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Elearning extends MY_Controller {

    public $site = 'Al Hukama International School | Parents';
    public $layout = 'parents/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('parent_logged_in')) {
            redirect('parents/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('parents/parent_model', 'ParentModel');
		$this->data['parent_data'] = $this->CommonModel->get_row('parents', $this->session->userdata('parent_id')); 
    }

    public function index() {
        $this->data['title'] = 'Online Results | Home';
		$this->data['content'] = 'elearning';
		$students = $this->ParentModel->getStudent($this->data['parent_data']->PR_number);
		$this->data['students'] = $students;
		$this->load->view($this->layout, $this->data);
    }
	
	public function list_papers($stdid) {
        $this->data['title'] = 'Online Results | Home';
		$this->data['content'] = 'list_paper';
		$student = $this->ParentModel->get_single_student($stdid);
		$this->data["papers"] = $this->ParentModel->get_papers($student["classid"] , $student["sectionid"]);
		$this->data["student"] = $this->ParentModel->get_single_student($stdid);
		$this->data['students'] = $this->ParentModel->getStudent($this->data['parent_data']->PR_number);
		$this->data["stdid"] = $stdid;
		$this->load->view($this->layout, $this->data);
    }
	
	public function view_paper($paper_id , $stdid) {
		$paper = $this->ParentModel->get_paper($paper_id);
		if($this->input->post())
		{
		  $decode = json_decode($paper["paper"],true);
		  //echo "<pre>";print_r($this->input->post());exit;	
		  $answer = $this->input->post("answer");
		  foreach($answer as $key => $val)
		  {
		    if(is_array($val))
			{
				foreach($val as $val1)
				{
				  if($decode[$key]["choices"][$val1]["sel"] == 1)
				  {
				    $sel[$key] = 10;	  
				  }
				  else
				  {
					$sel[$key] = 0;  
				  }	
				}
			}
			else
			{
				if($decode[$key]["choices"][$val]["sel"] == 1)
				{
				  $sel[$key] = 10;	
				}
				else
				{
				  $sel[$key] = 0;	
				}
			}
		  }
		  $marks_obt= 0;
		  foreach($sel as $sel)
		  {
		    $marks_obt += $sel;	  
		  }
		  $data_insrt = array(
		                  "answers" => json_encode($answer),
						  "stdid" => $stdid,
						  "paper_id" => $paper_id,
						  "marks_obt" => $marks_obt
		                     );
	      $this->db->insert("tbl_paper" , $data_insrt);
		  redirect(base_url("parents/elearning/list_papers/".$stdid.""));						 
		}
		
        $this->data['title'] = 'Online Results | Home';
		$this->data['content'] = 'view_paper';
		$this->data["paper"] = $paper;
		$this->data["answer"] = $this->ParentModel->get_answer($paper_id , $stdid);
		$this->load->view($this->layout, $this->data);
    }
}