<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Documents extends MY_Controller {

    public $site = 'Beladi International School | Parents';
    public $layout = 'parents/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('parent_logged_in')) {
            redirect('parents/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('parents/Documents_model', 'DocumentsModel');
		$this->data['parent_data'] = $this->CommonModel->get_row('parents', $this->session->userdata('parent_id')); 
    }

    public function index() {
        $this->data['title'] = 'Documents | Home';
		$this->data['content'] = 'documents';
		$this->load->model('parents/parent_model', 'ParentModel');
		$this->data['students'] = $this->ParentModel->getStudent($this->data['parent_data']->PR_number);
		
        $this->load->view($this->layout, $this->data);
    }
}