<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Attendance extends MY_Controller {

    public $site = 'Beladi International School | Parents';
    public $layout = 'parents/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('parent_logged_in')) {
            redirect('parents/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('parents/attendance_model', 'AttendanceModel');
		// Get Logged User
        $this->data['parent_data'] = $this->CommonModel->get_row('parents', $this->session->userdata('parent_id')); 
    }

    public function index() {
        $this->data['title'] = 'Attendance | Home';
		$this->data['content'] = 'attendance';
		$this->load->model('parents/parent_model', 'ParentModel');
		$this->data['students'] = $this->ParentModel->getStudent($this->data['parent_data']->PR_number);
		$students = $this->data['students'];
		$today_attendance = "";
		$attendance_history = "";
		$month_absents = "";
		if($students)
		{
			foreach ($students as $std)
			{
				$today_attendance [] = $this->AttendanceModel->getAttendance($std->stdid);
				$attendance_history [] = $this->AttendanceModel->getAttendanceHistory($std->stdid);
				
				$m_attendnce = $this->AttendanceModel->getMonthAbsents($std->stdid);
				if(!$m_attendnce->studentid)
				{
					$m_attendnce->studentid = $std->stdid;
				}
				$month_absents [$std->stdid] = $m_attendnce;
			}
			$this->data['month_absents'] = $month_absents;
			$this->data['today_attendance'] = $today_attendance;
			$this->data['attendance_history'] = $attendance_history;
		}
        $this->load->view($this->layout, $this->data);
    }
	public function reply_parent()
	{
		$post = $_POST;
		$this->AttendanceModel->reply_parent($post);
	}
	function get_attendance_count()
	{
		$post = $_POST;
		$result = $this->AttendanceModel->get_attendance_count($post);
		if($result)
		{
			echo $result->total_attendance;
		}
	}
}