<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Substituteteachers extends MY_Controller {

    public $site = 'Beladi International School | Principle';
    public $layout = 'owner/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('owner_logged_in')) {
            redirect('owner/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('principle/substitute_model', 'SubstituteModel');
		
		$this->data['principle_data'] = $this->CommonModel->get_row('owner', $this->session->userdata('owner_id')); 
//		$this->load->model('parents/appointment_model', 'AppointmentModel');
//		$this->data['confirmation_date']  = $this->AppointmentModel->get_confirmation_date($this->session->userdata['parent_id']); 
    }

    public function index() {
        $this->data['title'] = 'Substitute Teachers | Home';
		
		$teachers = $this->SubstituteModel->getAbsentteacher();
		
		$dayid = $this->SubstituteModel->getDayid();
		
		if($teachers)
		{
			foreach ($teachers as $t)
			{
				$t->timetable = $this->SubstituteModel->getTeacherstimetable($t->teacherid,$dayid->id);
				if($t->timetable)
				{
					foreach ($t->timetable as $time)
					{
						$teacherid = $this->SubstituteModel->getSelectedTeachers($time->id);
						if($teacherid)
						{
							$time->sub_teacherid = $teacherid->sub_teacherid;
							$time->sub_teacher_name = $teacherid->teacher_name;
						}
						else{
							$time->sub_teacherid = 0;
							$time->sub_teacher_name = "";
						}
					}
				}
			}
		}
		$this->data['teachers'] = $teachers;
		$this->data['content'] = 'substituteteachers';
        $this->load->view($this->layout, $this->data);
    }
	public function getfreeteahers()
	{
		$post = $_POST;
		$free_teachers = $this->SubstituteModel->getfreeteahers($post['period'],$post['dayid']);
		if($free_teachers)
		{
			$html = '<select name="teacher_list" class="form-control" onchange="add_timetable('.$post['teacherid'].','.$post['timetableid'].',this)">
				<option>Select Teacher</option>';
			foreach ($free_teachers as $free)
			{
				$selected = '';
				if($free->teacherid == $post['subteacherid'])
				{
					$selected = 'selected="selected"';
				}
				$html.= '<option '.$selected.' value="'.$free->teacherid.'">'.$free->teacher_name.'</option>';
			}
			$html.= '</select>';
		}
		else 
		{
			$html= 'No Free Teacher';
		}
		echo $html;
	}
	function add_timetable()
	{
		$post = $_POST;
		$this->SubstituteModel->addsubstituteteacher($post);
	}
}