<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class StudentFee extends MY_Controller {

    public $site = 'Beladi International School | Principle';
    public $layout = 'owner/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('owner_logged_in')) {
            redirect('owner/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        $this->data['content'] = '';
        $this->data['page_heading'] = '';
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('principle/accountant_model', 'AccountantModel');
		$this->data['principle_data'] = $this->CommonModel->get_row('owner', $this->session->userdata('owner_id')); 
        // Get Logged User
    }

    public function index() {
        $this->data['title'] = 'Student Fee | Home';
		$this->data['content'] = 'student_fee';
		if($_POST)
		{
			$post['classid'] = $_POST['classid'];
			$post['GR_number'] = $_POST['GR_number'];
			$post['paydate'] = date('Y-m-d',  strtotime($_POST['paydate']));
			$post['fee_id'] = $_POST['fee_id'];
			$this->AccountantModel->addStudentfee($post); 
			$this->data['insert'] = 'yes';
		}
		$this->data['classes'] = $this->AccountantModel->getClasses();
		$this->data['students'] = $this->AccountantModel->getStudents();
		$this->data['fees'] = $this->AccountantModel->getMonthlyfee();
		$this->data['stdfee'] = $this->AccountantModel->getStudentfee();
		
        $this->load->view($this->layout, $this->data);
    }	
	public function edit($id) {
        $this->data['title'] = 'Student Fee | Home';
		$this->data['content'] = 'studentfee_edit';
		if($_POST)
		{
			$post['classid'] = $_POST['classid'];
			$post['GR_number'] = $_POST['GR_number'];
			$post['paydate'] = date('Y-m-d',  strtotime($_POST['paydate']));
			$post['fee_id'] = $_POST['fee_id'];
			$this->AccountantModel->updateStudentfee($post,$id); 
			$this->data['insert'] = 'yes';
		}
		$this->data['classes'] = $this->AccountantModel->getClasses();
		$this->data['students'] = $this->AccountantModel->getStudents();
		$this->data['fees'] = $this->AccountantModel->getMonthlyfee();
		$this->data['stdfee'] = $this->AccountantModel->getStudentfee($id);
        $this->load->view($this->layout, $this->data);
    }	
}