<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class StdTodayAttendance extends MY_Controller {

    public $site = 'Beladi International School | Attendance';
    public $layout = 'owner/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('owner_logged_in')) {
            redirect('owner/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('principle/MarkStudent_model', 'MarkStudentModel');
		// Get Logged User
        $this->data['principle_data'] = $this->CommonModel->get_row('owner', $this->session->userdata('owner_id')); 
    }

    public function index() {
		$this->data['date'] = date('Y-m-d'); 
		$date = "";
		$classid = "";
		$sectionid = "";
		$this->data['students'] = "";
		$this->data['classid'] = "";
		$this->data['sectionid'] = "";
		
		if(isset($_POST['classid']) && $_POST['classid'] != "" && isset($_POST['sectionid']) && $_POST['sectionid'] != "")
		{
			$classid = $_POST['classid'];
			$sectionid = $_POST['sectionid'];
			$this->data['classid'] = $classid;
			$this->data['sectionid'] = $sectionid;
			$this->data['students'] = $this->MarkStudentModel->getstdList($classid, $sectionid);
			
			if($this->data['students'])
			{
				$day = date('D');
				if($day == 'Mon')
				{
					$dayid = 1;
				}
				else if($day == 'Tue')
				{
					$dayid = 2;
				}
				if($day == 'Wed')
				{
					$dayid = 3;
				}
				if($day == 'Thu')
				{
					$dayid = 4;
				}
				if($day == 'Fri')
				{
					$dayid = 5;
				}
				if($day == 'Sat')
				{
					$dayid = 6;
				}
				if($day == 'Sun')
				{
					$dayid = 7;
				}
				$subject_period = $this->MarkStudentModel->getSubjectid($dayid,$classid , $sectionid);
				if($subject_period)
				{
					$this->data['subjectid'] =  $subject_period->subjectid;
					$this->data['period_no'] =  $subject_period->period_no;
					$this->data['teacherid'] =  $subject_period->teacherid;
					$this->data['teacher_name'] =  $subject_period->teacher_name;
					$students = $this->data['students'];
					if($students)
					{ 
						$absent_students = 0;
						$present_students = 0;
						$bunk_students = 0;
						foreach ($students as$key=> $t) 
						{ 
							$this->db->select("status,message,subjectid,teacherid")->from("attendance");
							$this->db->where('date',date('Y-m-d'));
							$this->db->where('studentid',$t->stdid);
							$this->db->where('classid',$this->data['classid']);
							$this->db->where('sectionid',$this->data['sectionid']);
							$this->db->where('period_no',$this->data['period_no']);
							$this->db->where('subjectid',$this->data['subjectid']);
							$query = $this->db->get();
							if ($query->num_rows() > 0) 
							{
								$attend = $query->row();
								if($attend->status == 'A')
								{
									$absent_students++;
								}
								else if($attend->status == 'P')
								{
									$present_students++;
								}
								else
								{
									$bunk_students++;
								}
							} else {
								$attend = FALSE;
							}
							$t->attendance = $attend;
						}
						$this->data['students'] = $students;
						$this->data['absent_student'] = $absent_students;
						$this->data['present_student'] = $present_students;
						$this->data['bunk_student'] = $bunk_students;
					}
				}
				else
				{
					$this->data['students'] = "";
				}
				
				
			}
		}
		$this->data['content']  = 'stdTodayAttendance';
		$this->data['classes']  = $this->CommonModel->get_all_rows('classes'); 
		$this->data['sections']  = $this->CommonModel->get_all_rows('sections'); 
		$this->load->view($this->layout, $this->data);
    }
	function getChilds($pr_number)
	{
		$childs = $this->Webservicemodel->getChilds($pr_number); 
		return $childs;
	}
	function sendNotification($message,$title,$reg_id)
	{
		
		$url = 'https://fcm.googleapis.com/fcm/send';
 
       
		$message['title'] = $title;
		
		$fields = array(
            'to' => $reg_id,
            'data' => $message,
        );
		//print_R($fields);die;
		//echo json_encode($fields);die;
        // Set POST variables
        $url = 'https://fcm.googleapis.com/fcm/send';
 
        $headers = array(
            'Authorization: key=' . FIREBASE_API_KEY,
            'Content-Type: application/json'
        );
        // Open connection
        $ch = curl_init();
 
        // Set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_URL, $url);
 
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
 
        // Disabling SSL Certificate support temporarly
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
 
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
 
        // Execute post
        $result = curl_exec($ch);
        if ($result === FALSE) {
            die('Curl failed: ' . curl_error($ch));
        }
 
        // Close connection
        curl_close($ch);
		return $result;
	} 
	
	public function print_sabsents($date='')
	{
		$this->data['students'] = $this->stdAbsentsModel->getstdAbsents($date,'','');
		$this->load->library('mpdf/mpdf');
		
		$html = $this->load->view('owner/sabsents_print', $this->data, true);
		$mpdf = new mPDF('ar-s', 'A4', '', 'Arial', 16, 16, 12, 12, 9, 9);
		// $html = iconv("windows-1256","UTF-8//IGNORE",$html);
		$mpdf->SetDisplayMode('fullpage');
		$mpdf->list_indent_first_level = 0; // 1 or 0 - whether to indent the first level of a list
		// LOAD a stylesheet
		$stylesheet = file_get_contents('./assets/css/pdf.css');
		$mpdf->WriteHTML($stylesheet, 1);    // The parameter 1 tells that this is css/style only and no body/html/text
		//$mpdf->SetHTMLFooter($footer);
		$mpdf->SetFooter($this->data['settings']->site_name . '|{PAGENO}|' . date(DATE_RFC822));
		$mpdf->WriteHTML($html, 2);

		$file_name = date('Y_m_d_His') . '_fee_list.pdf';
		$mpdf->Output($file_name, 'I'); // F = Move to Directory, I = View, D = Download  
        $this->load->view($this->layout, $this->data);
	}
	
	
}