<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Profile extends MY_Controller {

    public $site = 'Beladi International School | Principle';
    public $layout = 'owner/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('owner_logged_in')) {
            redirect('owner/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        $this->data['content'] = '';
        $this->data['page_heading'] = '';
        $this->data['profile'] = 'profile';
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('owner/auth_model', 'AuthModel');
        // Get Logged User
        $this->data['principle_data'] = $this->CommonModel->get_row('owner', $this->session->userdata('owner_id')); 
    }

    public function index() {
        $this->data['title'] = 'Profile | Home';
		$this->data['content'] = 'profile';
		//	$this->data['students'] = $this->ParentModel->getStudent($this->data['parent_data']->ptid);
        $this->load->view($this->layout, $this->data);
    }
	
	public function edit() {
		$this->data['action'] = 'edit';
        $this->data['title'] = 'Profile | Home';
		$this->data['content'] = 'profile_edit';
		$profile_data = $this->CommonModel->get_row('owner', $this->session->userdata('owner_id'));
		if($_POST)
		{
			if($profile_data->username != $_POST['username'])
			$post['username'] = $_POST['username'];
			if($profile_data->password != $_POST['password'])
			$post['password'] = $_POST['password'];
			$post['name'] = $_POST['name'];
			$post['email'] = $_POST['email'];
			$post['mobile'] = $_POST['mobile'];
			$post['address'] = $_POST['address'];
			$post['detail'] = $_POST['detail'];
			$this->AuthModel->updateProfile($post,$this->session->userdata('owner_id')); 
			$this->data['update'] = 'yes';
		}
		$this->data['profile_data'] = $profile_data; 
        $this->load->view($this->layout, $this->data);
    }

    public function dashboard()
	{
        $this->data['title'] = 'Dashboard | Home';
		$this->data['content'] = 'dashboard';
//		$this->load->model('parents/fee_model', 'FeeModel');
//		$this->load->model('parents/exams_model', 'ExamsModel');
//		$this->data['students'] = $this->ParentModel->getStudent($this->data['parent_data']->ptid);
//		$this->data['events'] = $this->CommonModel->get_all_rows('events');
//		$students = $this->data['students'];
//		$birthdays = "";
//		$attendance = "";
//		$fee_alert = "";
//		$this->data['students'] = $this->ParentModel->getStudent($this->data['parent_data']->ptid);
//		$students = $this->data['students'];
//		$exams = '';
//		$home_work = "";
//		if($students)
//		{
//			foreach ($students as $std)
//			{
//				$birthday = $this->CommonModel->get_today_birthday($std->stdid);
//				$attend = $this->CommonModel->get_today_attendace($std->stdid);
//				$exams [$std->stdid] = $this->ExamsModel->getExams($std->stdid);
//				if($birthday)
//				{
//					$birthdays[] = $birthday;
//				}
//				if($attend)
//				{
//					$attendance[] = $attend;
//				}
//				$fee_alert[$std->stdid] = $this->FeeModel->fee_alert($std->stdid);
//				$home_work[$std->stdid] = $this->CommonModel->search_row("homework",$std->stdid);
//			}
//			$this->data['fee_alerts'] = $fee_alert;
//			$this->data['birthdays'] = $birthdays;
//			$this->data['attendance'] = $attendance;
//			$this->data['exams'] = $exams;
//			$this->data['home_work'] = $home_work;
//		}
//		else
//		{
//			$this->data['birthdays'] = "";
//		}
        $this->load->view($this->layout, $this->data);
    }

    public function settings() {
        $this->data['page_heading'] = 'Profile';
        $this->data['heading'] = 'Application Owner Profile';
        $this->data['content'] = 'admin/profile/settings';
        $this->data['user']=$this->data['logged_admin'];
        $this->data['countries'] = $this->CommonModel->get_all_rows('country');
        $this->load->view($this->layout, $this->data);
    }
    public function changepassword(){
        $this->data['page_heading'] = 'Profile';
        $this->data['heading'] = 'Change Password';
        $this->data['content'] = 'admin/profile/change_pass';
        $this->load->view($this->layout, $this->data);
    }

    public function change_password() {
        $this->form_validation->set_rules('old_password', 'Old Password', 'trim|required|xss_clean');
        $this->form_validation->set_rules('new_password', 'New Password', 'trim|required|xss_clean');
        $this->form_validation->set_rules('confirm_password', 'Confirm Password', 'trim|required|matches[new_password]|xss_clean');

        if ($this->form_validation->run() == FALSE) {
            if (validation_errors()) {
                $this->session->set_flashdata('msg', '<h4 class="error_msg">' . validation_errors() . '</h4>');
            }
            redirect('admin/profile/settings');
        } else {
            $old_password = md5($this->input->post('old_password'));
            $admin_data = $this->CommonModel->get_row('admin', $this->session->userdata('admin_id'));
           if($this->input->post('new_password') == $this->input->post('old_password')){
               $this->session->set_userdata('msg','<h4 class="error_msg">Old and New password are same, Please choose different new Password!.</h4>');
                ///$this->session->set_flashdata('msg', '<h4 class="error_msg">Old and New password are same, Please choose different new Password!.</h4>');
                redirect('admin/profile/changepassword');
            }else if($old_password != $admin_data->password) {
                $this->session->set_userdata('msg','<h4 class="error_msg">Wrong old password </h4>');
                redirect('admin/profile/changepassword');
            }else{
                $this->CommonModel->update_admin_password($this->input->post('new_password'));
                $this->session->set_userdata('msg','<h4 class="error_msg">Your password has been changed successfully.</h4>');
                redirect('admin/profile/changepassword');
            }
        }
    }
    function change_info(){
        $data=array(
            'first_name'=>$this->input->post('first_name'),
            'last_name'=>$this->input->post('last_name'),
            'email' =>$this->input->post('email')
            );
        $this->CommonModel->update_admin($this->session->userdata('admin_id'),$data);
        $this->session->set_userdata('msg', 'Your info has been changed successfully.');
        redirect('admin/profile');
    }
	
	function get_events()
	{
		$post = $_POST;
		$events = $this->CommonModel->get_events($post);
		$html = "";
		if($events)
		{
			foreach ($events as $e) 
			{
				$html .= '<tr><td valign="top">'.$e->event_date.'</td> <td valign="top">'.$e->event_name.'</td><td valign="top">'.$e->description.'</td></tr>';
			}
		}
		else{
			$html = "No Event found";
		}
		
		echo $html;
	}
}