<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Grading extends MY_Controller {

    public $site = 'Al Hukama International School | Parents';
    public $layout = 'owner/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('owner_logged_in')) {
            redirect('owner/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        // Load models
        $this->load->model('principle/grading_model', 'grade');
		$this->load->model('common_model', 'CommonModel');
        // Get Logged Teacher
        $this->data['principle_data'] = $this->CommonModel->get_row('owner', $this->session->userdata('owner_id')); 
    }
	
  public function manage_subject()
  {
	$this->data['title'] = 'Papers';
    $this->data['content'] = 'manage_subject';
	$this->data['class'] = $this->grade->get_classes_info();
		
	$this->load->view($this->layout, $this->data);  
  }	
	
	
	
  public function assign_subject()
  {
	$this->data['title'] = 'Papers';
    $this->data['content'] = 'assign_subject';
		
	if($this->input->post())
	{
	  $this->grade->add_subject($this->session->userdata('principle_branchid'));
	  redirect(base_url("owner/grading/manage_subject"));	
	}
	$this->data['class'] = $this->grade->get_class_info($this->session->userdata('principle_branchid'));
	$this->data['subject'] = $this->grade->get_subject_info($this->session->userdata('principle_branchid'));
	$this->load->view($this->layout, $this->data);  
  }
  
  public function edit_assign_subject($class_id)
  {
	 $this->data['title'] = 'Papers';
     $this->data['content'] = 'edit_assign_subject';
		
	if($this->input->post())
	{
	  $this->grade->update_subject($this->session->userdata('principle_branchid') , $class_id);
	  redirect(base_url("owner/grading/manage_subject"));	
	}
	$this->data["form_data"] = $this->grade->get_assign_subject_info($this->session->userdata('principle_branchid') , $class_id);
	$this->data['class'] = $this->grade->get_class_info($this->session->userdata('principle_branchid'));
	$this->data['subject'] = $this->grade->get_subject_info($this->session->userdata('principle_branchid'));
	$this->data['class_id'] = $class_id;
	$this->load->view($this->layout, $this->data);   
  }
  
  public function manage_teacher()
  {
	$this->data['title'] = 'Papers';
    $this->data['content'] = 'manage_teacher';
	$this->data['teacher'] = $this->grade->get_teachers_info();
		
	$this->load->view($this->layout, $this->data);  
  }
  
  public function assign_teacher()
  {
	$this->data['title'] = 'Papers';
    $this->data['content'] = 'assign_teacher';
	
	if($this->input->post())
	{
	  $this->grade->add_teacher($this->session->userdata('principle_branchid'));
	  redirect(base_url("owner/grading/manage_teacher"));	
	}
	
	
	$this->data['class'] = $this->grade->get_class_info($this->session->userdata('principle_branchid'));
	$this->data['section'] = $this->grade->get_section_info($this->session->userdata('principle_branchid'));
	$this->data['teacher'] = $this->grade->get_teacher_info($this->session->userdata('principle_branchid'));
		
	$this->load->view($this->layout, $this->data);  
  }	
  
  public function edit_assign_teacher($pk_assign_tea_id)
  {
	$this->data['title'] = 'Papers';
    $this->data['content'] = 'edit_assign_teacher';
	
	if($this->input->post())
	{
	  $this->grade->update_teacher($pk_assign_tea_id , $this->session->userdata('principle_branchid'));
	  redirect(base_url("owner/grading/manage_teacher"));	
	}
	
	$this->data["form_data"] = $this->grade->get_assign_teacher_info($pk_assign_tea_id);
	$this->data['class'] = $this->grade->get_class_info($this->session->userdata('principle_branchid'));
	$this->data['section'] = $this->grade->get_section_info($this->session->userdata('principle_branchid'));
	$this->data['teacher'] = $this->grade->get_teacher_info($this->session->userdata('principle_branchid'));
		
	$this->load->view($this->layout, $this->data);  
  }	
	
}