<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class StudentFee extends MY_Controller {

    public $site = 'Beladi International School | Accountant';
    public $layout = 'accountant/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('accountant_logged_in')) {
            redirect('accountant/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        $this->data['content'] = '';
        $this->data['page_heading'] = '';
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('accountant/accountant_model', 'AccountantModel');
        // Get Logged User
    }

    public function index() {
        $this->data['title'] = 'Student Fee | Home';
		$this->data['content'] = 'student_fee';
		if($_POST)
		{
			$post['GR_number'] = $_POST['GR_number'];
			$post['amount'] = $_POST['amount'];
			$post['type'] = $_POST['type'];
			$post['vat'] = (isset($_POST['vat']))?1:0;
			$post['discount'] = $_POST['discount'];
			$post['paydate'] = date('Y-m-d',  strtotime($_POST['paydate']));
			$this->AccountantModel->addStudentfee($post); 
			$this->data['insert'] = 'yes';
		}
		$this->data['classes'] = $this->AccountantModel->getClasses();
		$this->data['students'] = $this->AccountantModel->getStudents();
		$this->data['fees'] = $this->AccountantModel->getMonthlyfee();
		$this->data['stdfee'] = $this->AccountantModel->getStudentfee();
		$this->data['branches'] = $this->AccountantModel->getAllBranches();
        $this->load->view($this->layout, $this->data);
    }	
	public function edit($id) {
        $this->data['title'] = 'Student Fee | Home';
		$this->data['content'] = 'studentfee_edit';
		if($_POST)
		{
			$post['classid'] = $_POST['classid'];
			$post['GR_number'] = $_POST['GR_number'];
			$post['paydate'] = date('Y-m-d',  strtotime($_POST['paydate']));
			$post['fee_id'] = $_POST['fee_id'];
			$this->AccountantModel->updateStudentfee($post,$id); 
			$this->data['insert'] = 'yes';
		}
		$this->data['classes'] = $this->AccountantModel->getClasses();
		$this->data['students'] = $this->AccountantModel->getStudents();
		$this->data['fees'] = $this->AccountantModel->getMonthlyfee();
		$this->data['stdfee'] = $this->AccountantModel->getStudentfee($id);
		$this->data['branches'] = $this->AccountantModel->getAllBranches();
        $this->load->view($this->layout, $this->data);
    }	
	public function getStudentinfo()
	{
		$stdid = $_POST['stdid'];
		$students = $this->AccountantModel->getStudentinfo($stdid);
		echo json_encode($students);
		
	}
	public function pendingStudentFee($date='')
	{
		$students = $this->AccountantModel->getStudentsinfo();
		if($students)
		{
			foreach ($students as $std)
			{
				$fee = $this->AccountantModel->pendingStudentFee($date,$std->GR_number);
				if($fee)
				{
					unset($std);
				}
			}
		}
		$this->data['students'] = $students;
		$this->data['content'] = 'pending_fee';
		$this->load->view($this->layout, $this->data);
	}
	public function takeStudentFee($date='')
	{
		$PR_number = "";
		$GR_number = "";
		$students_fees = "";
		$parents = $this->AccountantModel->getAllParents();
		if($_POST)
		{
			$PR_number = $_POST['PR_number'];
			$GR_number = $_POST['GR_number'];
			$students_fees = $this->AccountantModel->getStudentsFees($PR_number,$GR_number);
		}
		$this->data['parents'] = $parents;
		$this->data['GR_number'] = $GR_number;
		$this->data['PR_number'] = $PR_number;
		$this->data['students_fees'] = $students_fees;
		$this->data['content'] = 'take_student_fees';
		$this->load->view($this->layout, $this->data);
	}
	public function getParentStudent()
	{
		$PR_number = $_POST['PR_number'];
		$students = $this->AccountantModel->getParentStudent($PR_number);
		echo json_encode($students);
		
	}
	public function studentFeeVoucher($PR_number='',$GR_number='')
	{
		$students_fees = "";
		$this->data['PR_number'] = $PR_number;
		$this->data['GR_number'] = $GR_number;
		$parent = $this->AccountantModel->getParentByPR($PR_number);
		$students_fees = $this->AccountantModel->getStudentsFees($PR_number,$GR_number);
		$this->data['parent'] = $parent;//print_r($parent);
		$this->data['students_fees'] = $students_fees;
		$this->data['content'] = 'student_fees_voucher';
		$this->load->view('accountant/layout_print', $this->data);
	}
}