<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class StudentCertificate extends MY_Controller {

    public $site = 'Beladi International School | Accountant';
    public $layout = 'accountant/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('accountant_logged_in')) {
            redirect('accountant/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        $this->data['content'] = '';
        $this->data['page_heading'] = '';
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('accountant/accountant_model', 'AccountantModel');
        // Get Logged User
    }

    public function index() {
        $this->data['title'] = 'Student Certificates | Home';
		$this->data['content'] = 'student_certificates';
		$this->data['students'] = $this->AccountantModel->getAllStudents();
        $this->load->view($this->layout, $this->data);
    }	
	public function leaving() {
		$this->data['title'] = 'Leaving Certificate | Home';
		$this->data['content'] = 'student_certificates';
		$this->data['students'] = $this->AccountantModel->getAllStudents();
        $this->load->view($this->layout, $this->data);
    }	
	public function leaving_create($PR_number='',$GR_number='')
	{
		$students_fees = "";
		$this->data['PR_number'] = $PR_number;
		$this->data['GR_number'] = $GR_number;
		$parent = $this->AccountantModel->getParentByPR($PR_number);
		$student = $this->AccountantModel->getStudentByGR($GR_number);
		$this->data['parent'] = $parent;//print_r($parent);
		$this->data['student'] = $student;
		$this->data['content'] = 'student_certificates_leaving';
		$this->load->view('accountant/layout_print', $this->data);
	}
}