<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class PendingFee extends MY_Controller {

    public $site = 'Beladi International School | Accountant';
    public $layout = 'accountant/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('accountant_logged_in')) {
            redirect('accountant/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        $this->data['content'] = '';
        $this->data['page_heading'] = '';
		 $this->load->library('pagination');
        // Load models
		$this->load->model('accountant/accountant_model', 'AccountantModel');
        // Get Logged User
    }

    public function index() {
        $this->data['title'] = 'Previous Fee | Home';
		$this->data['content'] = 'prev_fee';
		$limit = 30;
		$offset = 0;
		$config['total_rows'] = $this->AccountantModel->totalPreviousFee();
		if(isset($_GET['p']))
		{
			$offset = $_GET['p']*30;
			if($offset > $config['total_rows'])
			{
				$offset = $config['total_rows'] - 30;
			}
		}
		$this->data['fee'] = $this->AccountantModel->getPreviousFee($limit,$offset);
		
		$config['base_url']		= base_url()."accountant/PendingFee";
		$config['per_page']		= 30;
		$config['first_link']	= '<span>First</span>';
		$config['last_link']	= '<span>Last</span>';
		$config['next_link']	= '<span>Next &gt;&gt;</span>';
		$config['prev_link']	= '<span>&lt;&lt; Previous</span>';
		$config['num_links']	= 5;

		$this->pagination->initialize($config);
		$this->data['pagination'] = $this->pagination->create_links();
        $this->load->view($this->layout, $this->data);
    }	
	public function delete($id)
	{
		$this->AccountantModel->remove_data($id); 
		redirect(base_url()."accountant/PendingFee/index");
	}
	public function edit($id)
	{
		$this->data['content'] = 'prevfee_edit';
		if($_POST)
		{
			$post['paid_amount'] = $this->input->post('paid_amount');
			$this->AccountantModel->updatePrevfee($post, $id); 
		}
		$this->data['fee'] = $this->AccountantModel->getPreviousFeebyid($id); 
		$this->load->view($this->layout, $this->data);
	}
	
}