<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class ManageStudents extends MY_Controller {

    public $site = 'Beladi International School | Accountant';
    public $layout = 'accountant/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();

        // If user not logged in take user out from here
        if (!$this->session->userdata('accountant_logged_in')) {
            redirect('accountant/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        $this->data['content'] = '';
        $this->data['page_heading'] = '';
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('accountant/accountant_model', 'AccountantModel');
        // Get Logged User
    }

    public function index() {
        $this->data['title'] = 'Students | Home';
		$this->data['content'] = 'manage_students';
		$this->data['classes'] = $this->AccountantModel->getClasses();
		//$this->data['students'] = $this->AccountantModel->getStudents();
		//$this->data['fees'] = $this->AccountantModel->getMonthlyfee();
		//$this->data['stdfee'] = $this->AccountantModel->getStudentfee();
		$this->data['parents'] = $this->AccountantModel->getAllParents();
		$this->data['students'] = $this->AccountantModel->getAllStudents();
        $this->load->view($this->layout, $this->data);
    }	
	public function add() {
		$this->data['parent'] = '';
		$this->data['action'] = 'add';
        $this->data['title'] = 'Students | Home';
		$this->data['content'] = 'manage_students_addedit';
		if($_POST)
		{
			$post['branchid'] = $_POST['branchid'];
			$post['name'] = $_POST['name'];
			$post['gender'] = $_POST['gender'];
			$post['picture'] = $_POST['picture'];
			$post['classid'] = $_POST['classid'];
			$post['sectionid'] = $_POST['sectionid'];
			if(!empty($_POST['subject']))
			$post['subject'] = implode(",",$_POST['subject']);
			$post['GR_number'] = $_POST['GR_number'];
			$post['PR_number'] = $_POST['PR_number'];
			$post['email1'] = $_POST['email1'];
			$post['email2'] = $_POST['email2'];
			$post['student_password'] = $_POST['student_password'];
			$post['mobile1'] = $_POST['mobile1'];
			$post['mobile2'] = $_POST['mobile2'];
			$post['address'] = $_POST['address'];
			$post['nationality'] = $_POST['nationality'];
			$post['religion'] = $_POST['religion'];
			$post['description'] = $_POST['description'];
			$post['gps_location'] = $_POST['gps_location'];
			if(!empty($_POST['dob']))
			$post['dob'] = date('Y-m-d',strtotime($_POST['dob']));
			$post['iqama_no'] = $_POST['iqama_no'];
			if(!empty($_POST['iqama_expiry']))
			$post['iqama_expiry'] = date('Y-m-d',strtotime($_POST['iqama_expiry']));
			$post['license_no'] = $_POST['license_no'];
			if(!empty($_POST['license_expiry']))
			$post['license_expiry'] = date('Y-m-d',strtotime($_POST['license_expiry']));
			$post['passport_no'] = $_POST['passport_no'];
			if(!empty($_POST['passport_expiry']))
			$post['passport_expiry'] = date('Y-m-d',strtotime($_POST['passport_expiry']));
			$this->AccountantModel->addStudent($post); 
			$this->data['insert'] = 'yes';
		}
		$this->data['classes'] = $this->AccountantModel->getClasses();
		$this->data['branches'] = $this->AccountantModel->getAllBranches();
		$this->data['sections'] = $this->AccountantModel->getAllSections();
		$this->data['subjects'] = $this->AccountantModel->getAllSubjects();
        $this->load->view($this->layout, $this->data);
    }	
	public function edit($id) {
		$this->data['action'] = 'edit';
        $this->data['title'] = 'Students | Home';
		$this->data['content'] = 'manage_students_addedit';
		if($_POST)
		{
			$post['branchid'] = $_POST['branchid'];
			$post['name'] = $_POST['name'];
			$post['gender'] = $_POST['gender'];
			$post['picture'] = $_POST['picture'];
			$post['classid'] = $_POST['classid'];
			$post['sectionid'] = $_POST['sectionid'];
			if(!empty($_POST['subject']))
			$post['subject'] = implode(",",$_POST['subject']);
			$post['GR_number'] = $_POST['GR_number'];
			$post['PR_number'] = $_POST['PR_number'];
			$post['email1'] = $_POST['email1'];
			$post['email2'] = $_POST['email2'];
			$post['student_password'] = $_POST['student_password'];
			$post['mobile1'] = $_POST['mobile1'];
			$post['mobile2'] = $_POST['mobile2'];
			$post['address'] = $_POST['address'];
			$post['nationality'] = $_POST['nationality'];
			$post['religion'] = $_POST['religion'];
			$post['description'] = $_POST['description'];
			$post['gps_location'] = $_POST['gps_location'];
			if(!empty($_POST['dob']))
			$post['dob'] = date('Y-m-d',strtotime($_POST['dob']));
			$post['iqama_no'] = $_POST['iqama_no'];
			if(!empty($_POST['iqama_expiry']))
			$post['iqama_expiry'] = date('Y-m-d',strtotime($_POST['iqama_expiry']));
			$post['license_no'] = $_POST['license_no'];
			if(!empty($_POST['license_expiry']))
			$post['license_expiry'] = date('Y-m-d',strtotime($_POST['license_expiry']));
			$post['passport_no'] = $_POST['passport_no'];
			if(!empty($_POST['passport_expiry']))
			$post['passport_expiry'] = date('Y-m-d',strtotime($_POST['passport_expiry']));
			$this->AccountantModel->updateStudent($post,$id); 
			$this->data['insert'] = 'yes';
		}
		$this->data['classes'] = $this->AccountantModel->getClasses();
		$this->data['branches'] = $this->AccountantModel->getAllBranches();
		$this->data['sections'] = $this->AccountantModel->getAllSections();
		$this->data['subjects'] = $this->AccountantModel->getAllSubjects();
		$this->data['student'] = $this->AccountantModel->getStudent($id);
        $this->load->view($this->layout, $this->data);
    }
	public function getBranchSections()
	{
		echo $branchid = $_POST['branchid'];
		//$students = $this->AccountantModel->getParentStudent($PR_number);
		//echo json_encode($students);
		
	}
}