<?php

if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class ManageParents extends Accountant_Controller {

    public $site = 'Beladi International School | Accountant';
    public $layout = 'accountant/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();
		
		$this->load->library('Grocery_CRUD');
		$this->load->library('form_builder');
		
        // If user not logged in take user out from here
        if (!$this->session->userdata('accountant_logged_in')) {
            redirect('accountant/auth');
        }
            
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        $this->data['content'] = '';
        $this->data['page_heading'] = '';
        // Load models
        $this->load->model('common_model', 'CommonModel');
		$this->load->model('accountant/accountant_model', 'AccountantModel');
        // Get Logged User
    }

    public function index() {
        $this->data['title'] = 'Parents | Home';
		$this->data['content'] = 'manage_parents';
		$this->data['parents'] = $this->AccountantModel->getAllParents();
        $this->load->view($this->layout, $this->data);
    }	
	
	public function add() {
        $this->data['parent'] = '';
		$this->data['action'] = 'add';
		$this->data['title'] = 'Parents | Home';
		$this->data['content'] = 'manage_parents_addedit';
		if($_POST)
		{
			$post['PR_number'] = $_POST['PR_number'];
			$post['username'] = $_POST['username'];
			$post['parent_password'] = $_POST['parent_password'];
			$post['father_name'] = $_POST['father_name'];
			$post['father_mobile'] = $_POST['father_mobile'];
			$post['father_email'] = $_POST['father_email'];
			$post['father_iqama'] = $_POST['father_iqama'];
			$post['father_iqama_expiry'] = $_POST['father_iqama_expiry'];
			$post['father_passport'] = $_POST['father_passport'];
			if(!empty($_POST['father_passport_expiry']))
			$post['father_passport_expiry'] = date('Y-m-d',strtotime($_POST['father_passport_expiry']));
			$post['mother_name'] = $_POST['mother_name'];
			$post['mother_mobile'] = $_POST['mother_mobile'];
			$post['mother_email'] = $_POST['mother_email'];
			$post['mother_iqama'] = $_POST['mother_iqama'];
			$post['mother_iqama_expiry'] = $_POST['mother_iqama_expiry'];
			$post['address'] = $_POST['address'];
			$post['gps_location'] = $_POST['gps_location'];
			$this->AccountantModel->addParent($post); 
			$this->data['insert'] = 'yes';
		}
		/*$this->data['classes'] = $this->AccountantModel->getClasses();
		$this->data['students'] = $this->AccountantModel->getStudents();
		$this->data['fees'] = $this->AccountantModel->getMonthlyfee();
		$this->data['stdfee'] = $this->AccountantModel->getStudentfee();*/
		
        $this->load->view($this->layout, $this->data);
    }	
	
	public function edit($id) {
        $this->data['action'] = 'edit';
		$this->data['title'] = 'Parents | Home';
		$this->data['content'] = 'manage_parents_addedit';
		if($_POST)
		{
			$post['PR_number'] = $_POST['PR_number'];
			$post['username'] = $_POST['username'];
			$post['parent_password'] = $_POST['parent_password'];
			$post['father_name'] = $_POST['father_name'];
			$post['father_mobile'] = $_POST['father_mobile'];
			$post['father_email'] = $_POST['father_email'];
			$post['father_iqama'] = $_POST['father_iqama'];
			$post['father_iqama_expiry'] = $_POST['father_iqama_expiry'];
			$post['father_passport'] = $_POST['father_passport'];
			if(!empty($_POST['father_passport_expiry']))
			$post['father_passport_expiry'] = date('Y-m-d',strtotime($_POST['father_passport_expiry']));
			$post['mother_name'] = $_POST['mother_name'];
			$post['mother_mobile'] = $_POST['mother_mobile'];
			$post['mother_email'] = $_POST['mother_email'];
			$post['mother_iqama'] = $_POST['mother_iqama'];
			$post['mother_iqama_expiry'] = $_POST['mother_iqama_expiry'];
			$post['address'] = $_POST['address'];
			$post['gps_location'] = $_POST['gps_location'];
			$this->AccountantModel->updateParent($post,$id); 
			$this->data['insert'] = 'yes';
		}
		$this->data['parent'] = $this->AccountantModel->getParent($id);
        $this->load->view($this->layout, $this->data);
    }	
}