<?php
if (!defined('BASEPATH'))
    exit('No direct script access allowed');

class Auth extends MY_Controller {

    public $site = 'Beladi International School | Accountant';
    public $layout = 'admin/common/layout';
    public $data = array();

    public function __construct() {
        parent::__construct();        
        // Prepare Data
        $this->data['site_name'] = $this->site;
        $this->data['title'] = $this->site;
        $this->data['content'] = '';
        $this->data['msg'] = '';
        $this->load->model('accountant/auth_model', 'AuthModel');
    }
    public function index() {
        $this->data['title'] = $this->site;
        $this->load->view('accountant/login', $this->data);
    }

    public function login() {
            $username = $this->input->post('username');
            $password = $this->input->post('password');
            $user = $this->AuthModel->login($username, $password);
            if ($user) {
                 $this->register_session($user);
            } else {
                $this->data['msg'] = '<p class="error">ERROR: Login failed.</p>';
                $this->load->view('accountant/login',  $this->data);
            }
    }


    public function register_session($accountant) {
        $this->session->set_userdata('accountant_id', $accountant->id);
        $this->session->set_userdata('accountant_logged_in', TRUE);
        redirect('accountant/profile/dashboard');
    }
   
    public function logout() {
        $this->session->unset_userdata('accountant_logged_in');
        $this->session->unset_userdata('accountant_id');
		$this->session->unset_userdata('accountant_branchid');

        $this->session->sess_destroy();

        redirect('accountant/auth');
    }
    

    function createRandomPassword() {
        $chars = "abcdefghiHKJHIUHIUHKJNKNKJjkmnopqrstuvwxyz023456789";
        srand((double) microtime() * 1000000);
        $i = 0;
        $pass = '';
        while ($i <= 7) {
            $num = rand() % 33;
            $tmp = substr($chars, $num, 1);
            $pass = $pass . $tmp;
            $i++;
        }

        return $pass;
    }
}