<?php
defined('BASEPATH') OR exit('No direct script access allowed');

/**
 * Home page
 */
class Webservice extends MY_Controller {

	public function __construct() {
        parent::__construct();
		$this->load->model('Webservice_model', 'Webservicemodel');
		define('FIREBASE_API_KEY', 'AAAAB915Wzs:APA91bGkpCcTOvjq21IEtLv6G_TYPKz7L14Rv_cClYVTYzcT8WwrNHbl30nKqIbGQTLiIkg8oXVoUUIexw6794ZujofLCUA484ZMpwjoXBuZIReRN2M1qhJ7VtzYKtsJjeYN774TGaCh');
		$this->load->model('Common_model', 'CommonModel');
	}
	public function login()
	{
		$username = $_REQUEST['username'];
		$password = $_REQUEST['password']; 
		if($username && $password)
		{
			$userDetails = $this->Webservicemodel->login($username,$password);
			if($userDetails)
			{
				if($userDetails->type == 'parent')
				{
					$students = $this->Webservicemodel->get_students_by_pr($userDetails->PR_number);
					$userDetails->student_list = $students;
				}
				if($userDetails->type == 'teacher')
				{
					$userDetails->picture = str_replace(" ","%20",base_url()."assets/uploads/pictures/".$userDetails->picture);
					$userDetails->detail = strip_slashes(preg_replace('~[\r\n\t]+~',"",strip_tags($userDetails->detail)));
				}
				if(isset($userDetails->branchid) && $userDetails->type != 'parent')
				{
					$branch = $this->Webservicemodel->get_branch_name($userDetails->branchid);
					if($branch)
					{
						$userDetails->branch_name = $branch->branch_name;
					}
				}
				$result_json = array(
							'status' => 'success',
							'response' => $userDetails 
				);

			}
			else
			{
				$result_json = array(
							'status' => 'failed',
							'response' => 'Invalid login information.'
				);
			}
		}
		else
		{
			$result_json = array(
							'status' => 'failed',
							'response' => 'Invalid login information.'
				);
		}
		echo json_encode($result_json);
	}
	public function updateRegistrationId()
	{
		$user_id = $_REQUEST['user_id'];
		$token = $_REQUEST['token'];
		$type = $_REQUEST['type'];
		$this->updateAccessToken($user_id,$token,$type);
		$result_json = array(
					'status' => 'success',
					'response' => 'Token is updated.'
		);
		echo json_encode($result_json);
	}

	public function updateAccessToken($userid,$token,$type)
	{
		$post['userid'] = $userid;
		$post['reg_id'] = $token;
		$post['table'] = $type;
		if($type == 'parents')
		{
			$post['user'] = 'ptid';
		} 
		else if($type == 'teacher')
		{
			$post['user'] = 'teacherid';
		}
		else if($type == 'principal')
		{
			$post['user'] = 'id';
		}
		$this->Webservicemodel->updateAccessToken($post,$token,$type);
	}
	
	public function updateDeviceToken()
	{
		$post['userid'] = $_REQUEST['userid'];;
		$post['device_token'] = $_REQUEST['token'];
		$post['table'] = $_REQUEST['type'];
		$type = $post['table'];
		if($type == 'parents')
		{
			$post['user'] = 'ptid';
		} 
		else if($type == 'teacher')
		{
			$post['user'] = 'teacherid';
		}
		else if($type == 'principal')
		{
			$post['user'] = 'id';
		}
		$this->Webservicemodel->updateDeviceToken($post,$post['device_token'],$post['table']);
		$result_json = array(
					'status' => 'success',
					'response' => 'Device Token is updated.'
		);
		echo json_encode($result_json);
	}
	
	public function get_online_results()
	{
		$pr_number = $_REQUEST['pr_number'];
		$students = $this->Webservicemodel->get_students_by_pr($pr_number);
		if($students)
		{
			$online_results = array();
			foreach ($students as $s) 
			{
				$results = $this->Webservicemodel->get_online_results($s->Gr_number);
				if($results)
				{
					$s->result_file_path = str_replace(" ","%20",base_url()."assets/uploads/online_results/".$results->file_path);
					$s->result_date = $results->result_date;
					$s->status = 1;
					$s->term = $results->term;
				}
				else
				{
					$s->result = 'Not Uploaded yet.';
					$s->status = 0;
				}
				$result_json = array(
					'status' => 'success',
					'response' => $students 
				);
			}
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No student found.'
			);
		}
		echo json_encode($result_json);
	}
	public function online_results_by_gr()
	{
		$gr_number = $_REQUEST['gr_number'];
		$results = $this->Webservicemodel->get_online_results($gr_number);
		if($results)
		{
			$results->file_path = str_replace(" ","%20",base_url()."assets/uploads/online_results/".$results->file_path);
			$result_json = array(
					'status' => 'success',
					'response' => $results 
				);
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No result found for this student.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	public function getstudentTransportation()
	{
		$pr_number = $_REQUEST['pr_number'];
		$students = $this->Webservicemodel->getStudent($pr_number);
		$std_transport = "";
		if($students)
		{
			foreach ($students as$key=> $std) 
			{
				$students [$key]->driver_info = $this->Webservicemodel->get_students_transport($std->stdid); 
			}
			$result_json = array(
					'status' => 'success',
					'response' => $students 
				);
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No result found for this student.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	public function addSuggestions()
	{
		$post['userid'] = $_REQUEST['pr_number'];
		$post['title'] = $_REQUEST['title'];
		$post['description'] = $_REQUEST['description'];
		$post['type'] = $_REQUEST['type'];
		$post['date'] = date("Y-m-d");
		$insert_id = $this->Webservicemodel->addSuggestions($post); 
		if($insert_id)
		{
			$result_json = array(
					'status' => 'success',
					'response' => 'Thank you , Suggestion has been added' 
				);
		}
		else
		{
			$result_json = array(
					'status' => 'failed',
					'response' => 'Sorry Suggestion has not been saved, please try again.' 
				);
		}
		echo json_encode($result_json);
	}
	public function getStudentProgress()
	{
		$pr_number = $_REQUEST['pr_number'];
		$students = $this->Webservicemodel->getStudent($pr_number);
		if($students)
		{
			foreach ($students as$key=> $std) 
			{
				$students [$key]->student_report = $this->Webservicemodel->get_students_progress($std->GR_number); 
			}
			$result_json = array(
					'status' => 'success',
					'response' => $students 
				);
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No result found for this student.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	public function getstudentHomework()
	{
		$pr_number = $_REQUEST['pr_number'];
		$students = $this->Webservicemodel->getStudent($pr_number);
		if($students)
		{
			foreach ($students as$key=> $std) 
			{
				$std->homework = $this->Webservicemodel->gethomeworktoday($std->classid,$std->sectionid);
				if($std->homework)
				{
					foreach ($std->homework as $homework)
					{
						if($homework->images)
						{
							
							$homework->images = str_replace(" ","%20",base_url()."assets/homework/".$homework->images);
						}
						if($homework->document)
						{
							$homework->document =  str_replace(" ","%20",base_url()."assets/homework/".$homework->document);
						}
					}
					
				}
			}
			$result_json = array(
						'status' => 'success',
						'response' => $students 
					);
		}
		else{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No student found.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	
	public function gethomeworktofrom()
	{
		$post['classid'] = $_REQUEST['classid'];
		$post['sectionid'] = $_REQUEST['sectionid'];
		
		if(isset($_REQUEST['teacherid']))
		{
			$post['teacherid'] = $_REQUEST['teacherid'];
		}
		if(isset($_REQUEST['period']))
		{
			$post['period'] = $_REQUEST['period'];
		}
		if(isset($_REQUEST['from_date']) && isset($_REQUEST['to_date']))
		{
			$post['from_date'] = $_REQUEST['from_date'];
			$post['to_date'] = $_REQUEST['to_date'];
		}
		$result = $this->Webservicemodel->gethomeworktofrom($post);
		
		if($result)
		{
			$result_json = array(
				'status' => 'success',
				'response' => $result 
			);

		}
		else
		{
			$result_json = array(
					'status' => 'failed',
					'response' => $result 
				);
		
		}
		$json = json_encode($result_json);
		echo $json;
	}
	
	public function addMessageFromParents()
	{
		$post['studentid']= $_REQUEST['studentid'];
		$post['parent_reply']= $_REQUEST['parent_msg'];
		$this->Webservicemodel->addMessageFromParents($post); 
		$result_json = array(
			'status' => 'success',
			'response' => 'Message has been sent' 
		);
		echo json_encode($result_json);
		
	}
	public function addAppointment()
	{
		$post['parent_id'] = $_REQUEST['parentid'];
		$post['appointment_for'] = $_REQUEST['appointment_for'];
		$post['appointment_date'] = $_REQUEST['date'];
		$post['description'] = $_REQUEST['description'];
		$post['type'] = 'sent';
		$insert_id = $this->Webservicemodel->addAppointment($post); 
		if($insert_id)
		{
			$result_json = array(
					'status' => 'success',
					'response' => 'Thank you , Appointment has been added' 
				);
		}
		else
		{
			$result_json = array(
					'status' => 'failed',
					'response' => 'Sorry Appointment has not been saved, please try again.' 
				);
		}
		echo json_encode($result_json);
	}
	public function myAppointments()
	{
		$parent_id = $_REQUEST['parentid'];
		$appointments = $this->Webservicemodel->myAppointments($parent_id);
		if($appointments){
			$result_json = array(
			'status' => 'success',
			'response' => $appointments
		);
		}
		else
		{
			$result_json = array(
				'status' => 'success',
				'response' => 'No appointment found.'
		);
		}
		
		echo json_encode($result_json);
	}
	public function receivedAppointments()
	{
		$parent_id = $_REQUEST['parentid'];
		$appointments = $this->Webservicemodel->apppointment_receives($parent_id);
		if($appointments){
			$result_json = array(
			'status' => 'success',
			'response' => $appointments
		);
		}
		else
		{
			$result_json = array(
				'status' => 'success',
				'response' => 'No appointment found.'
		);
		}
		
		echo json_encode($result_json);
	}

	public function addComplainbyparent()
	{
		$post['userid'] = $_REQUEST['pr_number'];
		$post['complaint_for'] = $_REQUEST['complaint_for'];
		$post['description'] = $_REQUEST['description'];
		$post['date'] = date("Y-m-d");
		$post['sender'] = 'parent';
		$post['receiver'] = $_REQUEST['sendto'];
		$insert_id = $this->Webservicemodel->addComplain($post); 
		if($insert_id)
		{
			$result_json = array(
					'status' => 'success',
					'response' => 'Thank you , Complaint has been added' 
				);
		}
		else
		{
			$result_json = array(
					'status' => 'failed',
					'response' => 'Sorry Complaint has not been saved, please try again.' 
				);
		}
		echo json_encode($result_json);
	}
	public function getComplaintsForParents()
	{
		$pr_number = $_REQUEST['pr_number'];
		$complaints = $this->Webservicemodel->getComplaintsForParents($pr_number);
		if($complaints)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $complaints 
				);
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Complaint found.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	public function getTodayStudentAttendance()
	{
		$pr_number = $_REQUEST['pr_number'];
		$students = $this->Webservicemodel->getStudent($pr_number);
		if($students)
		{
			foreach ($students as$key=> $std) 
			{
				$attendance = $this->Webservicemodel->getTodayStudentAttendance($std->stdid); 
				if($attendance)
				{
					$students [$key]->attendance = $attendance;
				}
				else
				{
					$students [$key]->attendance = "";
				}
			}
			$result_json = array(
					'status' => 'success',
					'response' => $students 
				);
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No attendance found.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	public function getstudentProfile()
	{
		$gr_number = $_REQUEST['gr_number'];
		$student = $this->Webservicemodel->getstudentProfile($gr_number); 
		if($student)
		{
			if($student->picture)
			{
				$student->picture = str_replace(" ","%20",base_url()."assets/uploads/pictures/".$student->picture);
			}
			else
			{
				$student->picture = str_replace(" ","%20",base_url()."assets/uploads/pictures/no-image.png");
			}
			$result_json = array(
					'status' => 'success',
					'response' => $student 
				);
		}
		else{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Student found.'
			);
		}
		
		echo json_encode($result_json);
		
	}
	public function getStudentExams()
	{
		$pr_number = $_REQUEST['pr_number'];
		$students = $this->Webservicemodel->getStudent($pr_number);
		$exams = '';
		if($students)
		{
			foreach ($students as $std)
			{
				$exams_list = $this->Webservicemodel->getExams($std->stdid,$std->classid,$std->sectionid);
				if($exams_list)
				{
					foreach ($exams_list as $e) 
					{
						$e->description = trim(preg_replace('/\s\s+/', ' ', $e->description));
						$e->description = strip_tags($e->description);
					}
				}
				$std->exams_info = $exams_list;
			}
		}
		if($students)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $students 
				);
		}
		else{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Student found.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	public function getStudentDocExpiry()
	{
		$pr_number = $_REQUEST['pr_number'];
		$students = $this->Webservicemodel->getStudentDocExpiry($pr_number);
		if($students)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $students 
				);
		}
		else{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Student found.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	public function getParentNotice()
	{
		$branchid = $_REQUEST['branchid'];
		$students = $this->Webservicemodel->getParentNotice($branchid);
		if($students)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $students 
				);
		}
		else{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Notice found.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	function get_attendance_count()
	{
		$post['studentid'] = $_REQUEST['studentid'];
		$post['from_date'] = $_REQUEST['from_date'];
		$post['to_date'] = $_REQUEST['to_date'];
		$result = $this->Webservicemodel->get_attendance_count($post);
		$count = array();
		if($result)
		{
			$count['total_count'] =  $result;
		}
		else{
			$count['total_count'] = 0;
		}
		$result_json = array(
					'status' => 'success',
					'response' => $count 
				);
			$json = json_encode($result_json);
		echo $json;
	}
	public function getStudentRanking()
	{
		$pr_number = $_REQUEST['pr_number'];
		$students = $this->Webservicemodel->getStudent($pr_number);
		if($students)
		{
			foreach ($students as$key=> $std) 
			{
				$students [$key]->student_ranking = $this->Webservicemodel->get_students_ranking($std->gr_number); 
			}
			$result_json = array(
					'status' => 'success',
					'response' => $students 
				);
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Student found.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	function parent_logout()
	{
		$result_json = array(
					'status' => 'success',
					'response' => 'You are logout successfully.'
		);
		echo json_encode($result_json);
	}
	function getStudentAttendHistory()
	{
		$pr_number = $_REQUEST['pr_number'];
		$students = $this->Webservicemodel->getStudent($pr_number);
		if($students)
		{
			foreach ($students as$key=> $std) 
			{
				$attendance = $this->Webservicemodel->getStudentAttendHistory($std->stdid); 
				if($attendance)
				{
					$students [$key]->attendance = $attendance;
				}
				else
				{
					$students [$key]->attendance = "";
				}
			}
			$result_json = array(
					'status' => 'success',
					'response' => $students 
				);
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No attendance found.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	function getStudentFeeHistory()
	{
		$pr_number = $_REQUEST['pr_number'];
		$students = $this->Webservicemodel->getStudent($pr_number);
		if($students)
		{
			foreach ($students as$key=> $std) 
			{
				$attendance = $this->Webservicemodel->getStudentFeeHistory($std->gr_number); 
				if($attendance)
				{
					$students [$key]->fee_info = $attendance;
				}
				else
				{
					$students [$key]->fee_info = "";
				}
			}
			$result_json = array(
					'status' => 'success',
					'response' => $students 
				);
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Student found.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	public function addTeacherSuggestions()
	{
		$post['userid'] = $_REQUEST['teacherid'];
		$post['title'] = $_REQUEST['title'];
		$post['description'] = $_REQUEST['description'];
		$post['type'] = 'teacher';
		$post['date'] = date("Y-m-d");
		$insert_id = $this->Webservicemodel->addSuggestions($post); 
		if($insert_id)
		{
			$result_json = array(
					'status' => 'success',
					'response' => 'Thank you , Suggestion has been added' 
				);
		}
		else
		{
			$result_json = array(
					'status' => 'failed',
					'response' => 'Sorry Suggestion has not been saved, please try again.' 
				);
		}
		echo json_encode($result_json);
	}
	public function getComplaintsForTeacher()
	{
		$teacherid = $_REQUEST['teacherid'];
		$complaints = $this->Webservicemodel->getComplaintsForTeacher($teacherid);
		if($complaints)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $complaints 
				);
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Complaint found.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	public function addComplainbyteacher()
	{
		$post['userid'] = $_REQUEST['teacherid'];
		$post['complaint_for'] = $_REQUEST['complaint_for'];
		$post['description'] = $_REQUEST['description'];
		$post['date'] = date("Y-m-d");
		$post['sender'] = 'teacher';
		$post['receiver'] = $_REQUEST['sendto'];
		$insert_id = $this->Webservicemodel->addComplain($post); 
		if($insert_id)
		{
			$result_json = array(
					'status' => 'success',
					'response' => 'Thank you , Complaint has been added' 
				);
		}
		else
		{
			$result_json = array(
					'status' => 'failed',
					'response' => 'Sorry Complaint has not been saved, please try again.' 
				);
		}
		echo json_encode($result_json);
	}
	public function getTeacherNotice()
	{
		$branchid = $_REQUEST['branchid'];
		$students = $this->Webservicemodel->getTeacherNotice($branchid);
		if($students)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $students 
				);
		}
		else{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Notice found.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	public function getTeacherProfile()
	{
		$teacherid = $_REQUEST['teacherid'];
		$teacher = $this->Webservicemodel->getTeacherProfile($teacherid); 
		if($teacher)
		{
			if($teacher->picture)
			{
				$teacher->picture = str_replace(" ","%20",base_url()."assets/uploads/pictures/".$teacher->picture);
			}
			else
			{
				$teacher->picture = str_replace(" ","%20",base_url()."assets/uploads/pictures/no-image.png");
			}
			$result_json = array(
					'status' => 'success',
					'response' => $teacher 
				);
		}
		else{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Student found.'
			);
		}
		
		echo json_encode($result_json);
		
	}
	public function addTeacherleave()
	{
		$post['userid'] = $_REQUEST['teacherid'];
		$post['reason'] = $_REQUEST['reason'];
		$post['description'] = $_REQUEST['description'];
		$post['from'] = $_REQUEST['from'];
		$post['to'] = $_REQUEST['to'];
		$post['sender'] = 'teacher';
		$post['status'] = 'Not approved';
		
		$this->Webservicemodel->addTeacherleave($post);
		$result_json = array(
			'status' => 'success',
			'response' => 'Your leave has been added' 
		);
		echo json_encode($result_json);
	}
	public function getTeacherleave()
	{
		$userid = $_REQUEST['teacherid'];
		$leaves = $this->Webservicemodel->getTeacherleave($userid);
		if($leaves)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $leaves 
			);
		}
		else{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Leave Request found.'
			);
		}
		echo json_encode($result_json);
	}
	function addStudentProgressReport()
	{
		$post['GR_number'] = $_REQUEST['GR_number'];
		$post['remarks'] = $_REQUEST['remarks'];
		$post['date'] = date('Y-m-d');
		$this->Webservicemodel->addStudentProgressReport($post);
		$result_json = array(
						'status' => 'success',
						'response' => 'Student Progress Report added.'
			);
		echo json_encode($result_json);
	}
	function getTeacherDocExpiry()
	{
		$teacherid = $_REQUEST['teacherid'];
		$teacher_data = $this->Webservicemodel->getTeacherDocExpiry($teacherid);
		$start = strtotime(date('Y-m-d'));
		if($teacher_data->iqama_expiry && $teacher_data->iqama_expiry !="0000-00-00")
		{
			$iqama_expiry = explode("/", $teacher_data->iqama_expiry);
			$y = $iqama_expiry[0];
			$m = $iqama_expiry[1];
			$d = $iqama_expiry[2];
			$end = jdtogregorian((int)((11 * $y + 3) / 30) + 354 * $y + 30 * $m - (int)(($m - 1) / 2) + $d + 1948440 - 385);
			$end = strtotime(date('Y-m-d',strtotime($end)));

			$iqama_expiry_count = ceil(abs($end - $start) / 86400);
			$teacher_data->iqama_expiry_count = $iqama_expiry_count;
		}
		$license_expiry_count = "";
		if($teacher_data->driving_license_expiry && $teacher_data->driving_license_expiry !="0000-00-00" )
		{
			$iqama_expiry = explode("/", $teacher_data->driving_license_expiry);
			$y = $iqama_expiry[0];
			$m = $iqama_expiry[1];
			$d = $iqama_expiry[2];
			$end = jdtogregorian((int)((11 * $y + 3) / 30) + 354 * $y + 30 * $m - (int)(($m - 1) / 2) + $d + 1948440 - 385);
			$end = strtotime(date('Y-m-d',strtotime($end)));

			$teacher_data->license_expiry_count = ceil(abs($end - $start) / 86400);
		}
		if($teacher_data->passport_expiry != '0000-00-00')
		{
			$end = strtotime($teacher_data->passport_expiry);
			$passport_expiry_count = ceil(abs($end - $start) / 86400);
			$teacher_data->passport_expiry_count = $passport_expiry_count;
		}
		
		if($teacher_data)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $teacher_data 
				);
		}
		else{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Teacher found.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	function Teachertodaytimetable()
	{
		$teacherid = $_REQUEST['teacherid'];
		$period = "";
		if(isset($_REQUEST['period']))
		{
			$period = $_REQUEST['period'];
		}
		$day = date('D');
		if($day == 'Mon')
		{
			$dayid = 1;
		}
		else if($day == 'Tue')
		{
			$dayid = 2;
		}
		if($day == 'Wed')
		{
			$dayid = 3;
		}
		if($day == 'Thu')
		{
			$dayid = 4;
		}
		if($day == 'Fri')
		{
			$dayid = 5;
		}
		if($day == 'Sat')
		{
			$dayid = 6;
		}
		if($day == 'Sun')
		{
			$dayid = 7;
		}
		$today_timetable['today_timetable'] = $this->Webservicemodel->getTimetable($dayid,$teacherid,$period);
		$total_period = count($today_timetable);
		if($period == "")
		{
			$today_timetable['substitute_period'] = $this->Webservicemodel->today_subtimetable($teacherid);
		}
		if($today_timetable['today_timetable'] || isset($today_timetable['substitute_period']) )
		{
			$result_json = array(
					'status' => 'success',
					'response' => $today_timetable
				);
		}
		else{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Timetable found for today.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	public function addhomework()
	{
		$imgName = "";
		$docName = "";
		if(isset($_FILES['image']))
		{
			$rnd = rand(0,99999);  
			$imgName = "{$rnd}-image-{$_FILES['image']['name']}"; 
			$imageName = "assets/homework/".$imgName;
			$done= move_uploaded_file($_FILES['image']['tmp_name'], $imageName);
		}
		if(isset($_FILES['document']))
		{
			$rnd = rand(0,99999);  
			$docName = "{$rnd}-document-{$_FILES['document']['name']}"; 
			$documentName = "assets/homework/".$docName;
			$done= move_uploaded_file($_FILES['document']['tmp_name'], $documentName);
		}
		
		$post['teacherid'] = $_REQUEST['teacherid'];
		$post['classid'] = $_REQUEST['classid'];
		$post['sectionid'] = $_REQUEST['sectionid'];
		$post['period'] = $_REQUEST['period'];
		$post['subjectid'] = $_REQUEST['subjectid'];
		$post['images'] = $imgName;
		$post['document'] = $docName;
		$post['description'] = $_REQUEST['description'];
		$post['date'] = date('Y-m-d');
		$post['status'] = 'N';
		$post['submission'] = 'N';
		$home_id = $this->Webservicemodel->addhomework($post);
		
		$resp['image_path'] = base_url()."assets/homework/".$imgName;
		$resp['document_path'] = base_url()."assets/homework/".$docName;
		$resp['description'] = $_REQUEST['description'];
		$resp['homework_id'] = $home_id;
		
		$result_json = array(
			'status' => 'success',
			'response' => $resp 
		);
		echo json_encode($result_json); 
	}
	public function getClassStudents()
	{
		$classid = $_REQUEST['classid'];
		$sectionid = $_REQUEST['sectionid'];
		$period = $_REQUEST['period'];
		$subjectid = $_REQUEST['subjectid'];
		$classStudenets = $this->Webservicemodel->getClassStudents($classid,$sectionid,$period,$subjectid);
		$result_json = array(
			'status' => 'success',
			'response' => $classStudenets 
		);
		echo json_encode($result_json); 
	}
	public function add_attendance()
	{
//		$students[1] = 'P';
//		$students[2] = 'A';
//		$students[3] = 'B';
//		$_POST['selected_val'] = $students;
//		$note[1] = 'he is present';
//		$note[2] = 'he is absent';
//		$note[3] = 'he is on bunk';
//		$_POST['note'] =$note;
		
		$students = json_decode($_REQUEST['student_array']);
		$note = json_decode($_REQUEST['note_array']);
		foreach ($students as $key=> $std) 
		{
			if($key != 0)
			{
				$post['teacherid'] =  $_REQUEST['teacherid'];
				$post['classid'] =  $_REQUEST['classid'];
				$post['sectionid'] =  $_REQUEST['sectionid'];
				$post['studentid'] = $key;
				$post['period_no'] = $_REQUEST['period'];
				$post['subjectid'] =  $_REQUEST['subjectid'];
				$post['status'] = $std;
				$post['message'] = $note->$key;
				if($post['message'] == "" && $post['status'] == "A")
				{
					$post['message'] = "Why you are absent ?";
				}
				if($post['status'] == "A")
				{
					$res = $this->Webservicemodel->getStudentParentReg($post['studentid']);
					if($res && isset($res['reg_id']))
					{
						$msg['message'] = $post['message'];
						$msg['userType'] = 'Parent';
						$msg['userid'] = $res['PR_number'];
						$msg['action'] = 'attendance';
						$this->sendNotification($msg,'Absent Student',$res['reg_id']);
					}
					if($res && isset($res['device_token']))
					{
						$msg['message'] = $post['message'];
						$msg['userType'] = 'Parent';
						$msg['userid'] = $res['PR_number'];
						$msg['action'] = 'attendance';
						$msg['studentid'] = $post['studentid'];
						$dev = "";
						if(isset($_REQUEST['dev']))
						{
							$dev = "yes";
						}
						$this->CommonModel->sendiOS($msg,'Absent Student',$res['device_token'],'parent',$dev);
					}
				}
				$post['date'] = date('Y-m-d');
				$this->Webservicemodel->Addattendance($post);
			}
		}
		$result_json = array(
			'status' => 'success',
			'response' => 'Class attendance added.' 
		);
		echo json_encode($result_json); 
	}
	public function teacherhomework()
	{
		$teacherid = $_REQUEST['teacherid'];
		$teacherhomework = $this->Webservicemodel->teacherhomework($teacherid);
		$result_json = array(
			'status' => 'success',
			'response' => $teacherhomework 
		);
		echo json_encode($result_json); 
	}
	function add_note()
	{
		$post['class_note'] = $_REQUEST['class_note'];
		$post['what_done'] = $_REQUEST['what_done'];
		$post['classid'] = $_REQUEST['classid'];
		$post['sectionid'] = $_REQUEST['sectionid'];
		$post['period_no'] = $_REQUEST['period'];
		$post['teacherid'] =  $_REQUEST['teacherid'];
		//update
		$this->db->where('date', date('Y-m-d'));
        $this->db->delete('class_feedback');
		
		$post['date'] = date('Y-m-d');
		$this->db->set($post);
        $insert = $this->db->insert("class_feedback");
        $this->db->insert_id();
		$result_json = array(
			'status' => 'success',
			'response' => 'class note added' 
		);
		echo json_encode($result_json); 
	}
	function get_classnote()
	{
		$classid = $_REQUEST['classid'];
		$sectionid = $_REQUEST['sectionid'];
		$period = $_REQUEST['period'];
		$date = $_REQUEST['date'];
		$teacherid = $_REQUEST['teacherid'];
		$result = $this->Webservicemodel->getClassNote($classid,$sectionid,$period,$date,$teacherid);
		if($result)
		{
			$result_json = array(
				'status' => 'success',
				'response' => $result 
			);
		}
		else
		{
			$result_json = array(
				'status' => 'failed',
				'response' => 'No class note found.' 
			);
		}
		
		echo json_encode($result_json); 
	}
	function teacherOfmonths()
	{
		$branchid = $_REQUEST['branchid'];
		$result = $this->Webservicemodel->teacherOfmonths($branchid);
		if($result)
		{
			$result_json = array(
				'status' => 'success',
				'response' => $result 
			);
		}
		else
		{
			$result_json = array(
				'status' => 'failed',
				'response' => 'No Teacher found.' 
			);
		}
		
		echo json_encode($result_json); 
	}
	function studentOfmonths()
	{
		$branchid = $_REQUEST['branchid'];
		$result = $this->Webservicemodel->studentOfmonths($branchid);
		if($result)
		{
			$result_json = array(
				'status' => 'success',
				'response' => $result 
			);
		}
		else
		{
			$result_json = array(
				'status' => 'failed',
				'response' => 'No Student found.' 
			);
		}
		
		echo json_encode($result_json); 
	}
	function getTeachertimetable()
	{
		$teacherid = $_REQUEST['teacherid'];
		$wtimetable = $this->Webservicemodel->get_wtimetable($teacherid);
		$timetable = "";
		if($wtimetable)
		{
			foreach ($wtimetable as $time) 
			{
				$timetable[$time->dayname] = $this->Webservicemodel->get_wtimetablebyday($time->dayid,$teacherid);
			}
		}
		if($timetable)
		{
			$result_json = array(
				'status' => 'success',
				'response' => $timetable 
			);
		}
		else
		{
			$result_json = array(
				'status' => 'failed',
				'response' => 'No Timetable found.' 
			);
		}
		
		echo json_encode($result_json); 
	}
	public function getTeacherduty()
	{
		$teacherid = $_REQUEST['teacherid'];
		$result = $this->Webservicemodel->getduty($teacherid);
		if($result)
		{
			$result_json = array(
				'status' => 'success',
				'response' => $result 
			);
		}
		else
		{
			$result_json = array(
				'status' => 'failed',
				'response' => 'No Teacher duty found.' 
			);
		}
		
		echo json_encode($result_json); 
	}
	function getTeacherdutieslist()
	{
		$branchid = $_REQUEST['branchid'];
		$result = $this->Webservicemodel->getTeacherduties($branchid);
		if($result)
		{
			$result_json = array(
				'status' => 'success',
				'response' => $result 
			);
		}
		else
		{
			$result_json = array(
				'status' => 'failed',
				'response' => 'No Teacher duty found.' 
			);
		}
		
		echo json_encode($result_json); 
	}
	function getTeacherMonthAbsents()
	{
		$teacherid = $_REQUEST['teacherid'];
		$result = $this->Webservicemodel->getTeacherMonthAbsents($teacherid);
		if($result)
		{
			$result_json = array(
				'status' => 'success',
				'response' => $result 
			);
		}
		else
		{
			$result_json = array(
				'status' => 'failed',
				'response' => 'No Teacher Absent found.' 
			);
		}
		
		echo json_encode($result_json); 
	}
	public function getTeacherTodayAttendance()
	{
		$teacherid = $_REQUEST['teacherid'];
		$result = $this->Webservicemodel->getTeacherAttendance($teacherid);
		if($result)
		{
			$result_json = array(
				'status' => 'success',
				'response' => $result 
			);
		}
		else
		{
			$result_json = array(
				'status' => 'failed',
				'response' => 'No Teacher Attendance found.' 
			);
		}
		
		echo json_encode($result_json); 
	}	
	public function getTeacherAttendanceHistory()
	{
		$teacherid = $_REQUEST['teacherid'];
		$result = $this->Webservicemodel->getAttendanceHistory($teacherid);
		if($result)
		{
			$result_json = array(
				'status' => 'success',
				'response' => $result 
			);
		}
		else
		{
			$result_json = array(
				'status' => 'failed',
				'response' => 'No Teacher Attendance found.' 
			);
		}
		
		echo json_encode($result_json); 
	}
	public function getTeacherSubstitutePeriods()
	{
		$teacherid = $_REQUEST['teacherid'];
		$substitutetimetable = $this->Webservicemodel->today_subtimetable($teacherid);
		if($substitutetimetable)
		{
			foreach ($substitutetimetable as$key=> $time) 
			{
				$time->lesson_info = $this->Webservicemodel->getLessoninfo($teacherid,$time->subjectid);
				$time->class_info = $this->Webservicemodel->getClassinfo($teacherid,$time->period_no,$time->classid,$time->sectionid);
			}
		}
		if($substitutetimetable)
		{
			$result_json = array(
				'status' => 'success',
				'response' => $substitutetimetable 
			);
		}
		else
		{
			$result_json = array(
				'status' => 'failed',
				'response' => 'No Teacher Substitute Period found.' 
			);
		}
		
		echo json_encode($result_json); 
	}
	public function getClassAttendance()
	{
		$teacherid = $_REQUEST['teacherid'];
		$classid = $_REQUEST['classid'];
		$sectionid = $_REQUEST['sectionid'];
		$period = $_REQUEST['period'];
		$subjectid = $_REQUEST['subjectid'];
		$date = "";
		if($_REQUEST['date'])
		{
			$date = $_REQUEST['date'];
		}
		$classAttendance = $this->Webservicemodel->getClassAttendance($teacherid,$classid,$sectionid,$period,$subjectid,$date);
		if($classAttendance)
		{
			$result_json = array(
				'status' => 'success',
				'response' => $classAttendance 
			);
		}
		else
		{
			$result_json = array(
				'status' => 'failed',
				'response' => 'No Class Attendance found.' 
			);
		}
		
		echo json_encode($result_json); 
	}
	public function getClassHomework()
	{
		$teacherid = $_REQUEST['teacherid'];
		$classid = $_REQUEST['classid'];
		$sectionid = $_REQUEST['sectionid'];
		$period = $_REQUEST['period'];
		$subjectid = $_REQUEST['subjectid'];
		$date = "";
		if($_REQUEST['date'])
		{
			$date = $_REQUEST['date'];
		}
		$classAttendance = $this->Webservicemodel->getClassHomework($teacherid,$classid,$sectionid,$period,$subjectid,$date);
		if($classAttendance)
		{
			foreach ($classAttendance as$key=> $attend) 
			{
				if($attend->images)
				{
					$attend->images = str_replace(" ","%20",base_url()."assets/homework/".$attend->images);
				}
				if($attend->document)
				{
					$attend->document = str_replace(" ","%20",base_url()."assets/homework/".$attend->document);
				}
			}
			$result_json = array(
				'status' => 'success',
				'response' => $classAttendance 
			);
		}
		else
		{
			$result_json = array(
				'status' => 'failed',
				'response' => 'No Class Homework found.' 
			);
		}
		
		echo json_encode($result_json); 
	}
	function getTeacherabsentCount()
	{
		$post['teacherid'] = $_REQUEST['teacherid'];
		$post['from_date'] = $_REQUEST['from_date'];
		$post['to_date'] = $_REQUEST['to_date'];
		$result = $this->Webservicemodel->getTeacherabsentCount($post);
		$count = array();
		if($result)
		{
			$count['total_count'] =  $result;
		}
		else{
			$count['total_count'] = 0;
		}
		$result_json = array(
					'status' => 'success',
					'response' => $count 
				);
			$json = json_encode($result_json);
		echo $json;
	}
	public function addMessageFromTeacher()
	{
		$post['teacherid']= $_REQUEST['teacherid'];
		$post['teacher_reply']= $_REQUEST['teacher_reply'];
		$post['date']= $_REQUEST['date'];
		$this->Webservicemodel->addMessageFromTeacher($post); 
		$result_json = array(
			'status' => 'success',
			'response' => 'Message has been sent' 
		);
		echo json_encode($result_json);
	}
	////////////////////////// Principal Webservices /////////////////////////
	public function getAllComplaints()
	{
		$branchid = $_REQUEST['branchid'];
		$respone['parents_complaints'] = $this->Webservicemodel->getparentComplaints($branchid); 
		$respone['teacher_complaints'] = $this->Webservicemodel->getteacherComplaints($branchid); 
		$respone['mycomplaintstoteacher'] = $this->Webservicemodel->myteacherComplaints($branchid);
		$respone['mycomplaintstoparents'] = $this->Webservicemodel->myparentsComplaints($branchid); 
		$result_json = array(
					'status' => 'success',
					'response' => $respone 
				);
			$json = json_encode($result_json);
		echo $json;
	}
	
	function getAllTeachersAttendanceHistory()
	{
		$branchid = $_REQUEST['branchid'];
		$date = '';
		if(isset($_REQUEST['date']))
		{
			$date = $_REQUEST['date'];
		}
		$respone['teachers_attendance'] = $this->Webservicemodel->getAllTeachersAttendanceHistory($branchid,$date); 
		$result_json = array(
					'status' => 'success',
					'response' => $respone 
				);
			$json = json_encode($result_json);
		echo $json;
	}
	public function getAbsentTeacherStudentCount()
	{
		$branchid = $_REQUEST['branchid'];
		$response['teacher_absent_count'] = $this->Webservicemodel->getTeacherAbsentCont($branchid); 
		$response['student_absent_count'] = $this->Webservicemodel->getStudentAbsentCont($branchid);
		$response['last_notice'] = $this->Webservicemodel->lastNotice($branchid); 
		$result_json = array(
					'status' => 'success',
					'response' => $response 
				);
			$json = json_encode($result_json);
		echo $json;
	}
	public function getTodayAbsentTeachers()
	{
		$branchid = $_REQUEST['branchid'];
		$teacherid = "";
		if(isset($_REQUEST['teacherid']))
		{
			$teacherid = $_REQUEST['teacherid'];		
		}
		$teachers = $this->Webservicemodel->getTodayAbsentTeachers($branchid,$teacherid); 
		$dayid = $this->Webservicemodel->getDayid();
		if($teachers)
		{
			foreach ($teachers as $t)
			{
				$t->timetable = $this->Webservicemodel->getTeacherstimetable($t->teacherid,$dayid->id);
				if($t->timetable)
				{
					foreach ($t->timetable as $time)
					{
						$teacherid = $this->Webservicemodel->getSelectedTeachers($time->id);
						if($teacherid)
						{
							$time->sub_teacherid = $teacherid->sub_teacherid;
							$time->teacher_name = $teacherid->teacher_name;
						}
						else{
							$time->sub_teacherid = 0;
							$time->teacher_name = "";
						}
					}
				}
			}
			$result_json = array(
					'status' => 'success',
					'response' => $teachers 
				);
		}
		else
		{
			$result_json = array(
					'status' => 'failed',
					'response' => 'No Absent Teacher Today found.'
				);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	public function Substituteteachers()
	{
		$period = $_REQUEST['period'];
		$dayid = $_REQUEST['dayid'];
		$branchid = $_REQUEST['branchid'];
		
		$teachers = $this->Webservicemodel->getfreeteahers($period,$dayid,$branchid);
		if($teachers)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $teachers 
				);
		}
		else
		{
			$result_json = array(
					'status' => 'failed',
					'response' => 'No Free Teacher found.' 
				);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	public function getPrincipleProfile()
	{
		$principal_id = $_REQUEST['principal_id'];
		$principal = $this->Webservicemodel->getPrincipleProfile($principal_id); 
		if($principal)
		{
			if($principal->picture)
			{
				$principal->picture = str_replace(" ","%20",base_url()."assets/uploads/pictures/".$principal->picture);
			}
			else
			{
				$principal->picture = str_replace(" ","%20",base_url()."assets/uploads/pictures/no-image.png");
			}
			$result_json = array(
					'status' => 'success',
					'response' => $principal 
				);
		}
		else{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Principal found.'
			);
		}
		
		echo json_encode($result_json);
		
	}
	function getFeeDefaulters()
	{
		$branchid = $_REQUEST['branchid'];
		$classid = $_REQUEST['classid'];
		$sectionid = $_REQUEST['sectionid'];
		
		$students = $this->Webservicemodel->get_students($classid,$sectionid,$branchid); 
		if($students)
		{
			foreach ($students as $s) 
			{
				$fee = $this->Webservicemodel->checkStudentfeeforCurrentMonth($s->GR_number);
				if($fee)
				{
					unset($s);
				}
			}
			$result_json = array(
					'status' => 'success',
					'response' => $students 
				);
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Fee Defaulter found.'
			);
		}
		echo json_encode($result_json);
	}
	function sendFeeDefaultersNotification()
	{
		$branchid = $_REQUEST['branchid'];
		$classid = $_REQUEST['classid'];
		$sectionid = $_REQUEST['sectionid'];
		
		$students = $this->Webservicemodel->get_studentparent($classid,$sectionid,$branchid); 
		if($students)
		{
			foreach ($students as $s) 
			{
				$fee = $this->Webservicemodel->checkStudentfeeforCurrentMonth($s->GR_number);
				if(!$fee)
				{
					// send notification to teacher
					$msg['message'] = 'Kindly pay your fee.';
					$msg['userType'] = 'Parent';
					$msg['userid'] = $s->PR_number;
					$msg['action'] = 'fee alerts';
					if($s->reg_id)
					{
						$this->sendNotification($msg,'Fee alert',$s->reg_id);
					}
					if($s->device_token)
					{
						$dev = "";
						if(isset($_REQUEST['dev']))
						{
							$dev = "yes";
						}
						$msg['studentid'] = $s->studentid;
						$this->CommonModel->sendiOS($msg,'Fee alert',$s->device_token,'parent',$dev);
					}
				}
			}
			$result_json = array(
					'status' => 'success',
					'response' => 'sent successfuly.' 
				);
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'not sent.'
			);
		}
		echo json_encode($result_json);
	}
	
	public function addsubstituteteacher()
	{
		$post['timetableid'] = $_REQUEST['timetableid'];
		$post['teacherid'] = $_REQUEST['teacherid'];
		$resp = $this->Webservicemodel->addsubstituteteacher($post); 
		
		// send notification to teacher
		$res = $this->CommonModel->getTeacherReg($post['teacherid']);
		$msg['message'] = 'Please check substitute period has been assigned to you.';
		$msg['userType'] = 'Teacher';
		$msg['userid'] = $post['teacherid'];
		$msg['action'] = 'substitute';
		if($res['reg_id'])
		{
			$this->sendNotification($msg,'Subsitute Period',$res['reg_id']);
		}
		$result_json = array(
					'status' => 'success',
					'response' => 'Substitute Teacher added.'
		);
		echo json_encode($result_json);
	}
	public function pendinghomework()
	{
		$branchid = $_REQUEST['branchid'];
		$date = '';
		if(isset($_REQUEST['date']))
		{
			$date = $_REQUEST['date'];
		}
		
		$pending_homework = $this->Webservicemodel->pendinghomework($branchid,$date); 
		if($pending_homework)
		{
			foreach ($pending_homework as $homework)
			{
				if($homework->images)
				{

					$homework->images = str_replace(" ","%20",base_url()."assets/homework/".$homework->images);
				}
				if($homework->document)
				{
					$homework->document =  str_replace(" ","%20",base_url()."assets/homework/".$homework->document);
				}
			}
			$result_json = array(
					'status' => 'success',
					'response' => $pending_homework 
				);
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Pending Homework found.'
			);
		}
		echo json_encode($result_json);
	}
	function deletehomework()
	{
		$post['teacherid'] = $_REQUEST['teacherid'];
		$post['classid'] = $_REQUEST['classid'];
		$post['sectionid'] = $_REQUEST['sectionid'];
		$post['period'] = $_REQUEST['period'];
		$post['subjectid'] = $_REQUEST['subjectid'];
		$post['date'] = $_REQUEST['date'];
		$this->Webservicemodel->deletehomework($post); 
		$result_json = array(
					'status' => 'success',
					'response' => 'homework is deleted.'
		);
		echo json_encode($result_json);
	}
	function approveHomework()
	{
		$post['teacherid'] = $_REQUEST['teacherid'];
		$post['classid'] = $_REQUEST['classid'];
		$post['sectionid'] = $_REQUEST['sectionid'];
		$post['period'] = $_REQUEST['period'];
		$post['subjectid'] = $_REQUEST['subjectid'];
		$post['status'] = $_REQUEST['status'];
		$post['date'] = $_REQUEST['date'];
		$result = $this->Webservicemodel->approveHomework($post);
		if($post['status'] == 'Y')
		{
			$result_json = array(
					'status' => 'success',
					'response' => 'homework is approved.'
			);
		}
		else if($post['status'] == 'N')
		{
			$result_json = array(
						'status' => 'success',
						'response' => 'homework is not approved.'
			);
		}
		
		echo json_encode($result_json);
	}
	function getAllNotice()
	{
		$branchid = $_REQUEST['branchid'];
		$notice = $this->Webservicemodel->getAllNotice($branchid);
		if($notice)
		{
			$result_json = array(
						'status' => 'success',
						'response' => $notice
			);
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Notice found.'
			);
		}
		echo json_encode($result_json);

	}
	function addNotice()
	{
		$post['branchid'] = $_REQUEST['branchid'];
		$post['title'] = $_REQUEST['title'];
		$post['description'] = $_REQUEST['description'];
		$post['type'] = $_REQUEST['type'];
		$post['date'] = $_REQUEST['date'];
		$this->Webservicemodel->addNotice($post);
		if($post['type'] == 'parents')
		{
			$parent_list = $this->Webservicemodel->parent_list($post['branchid']);
			if($parent_list)
			{
				foreach ($parent_list as $p) 
				{
					$res = $this->Webservicemodel->getParentDetail($p->PR_number);
					if($res['reg_id'])
					{
						$msg['message'] = $post['description'];
						$msg['userType'] = 'Parent';
						$msg['userid'] = 0;
						$msg['action'] = 'notification';
						$msg['branchid'] = $post['branchid'];
						$this->sendNotification($msg,$post['title'],$res['reg_id']);
					}
					if($res['device_token'])
					{
						$msg['message'] = $post['description'];
						$msg['userType'] = 'Parent';
						$msg['userid'] = $p->PR_number;
						$msg['action'] = 'notification';
						$msg['branchid'] = $post['branchid'];
						$dev = "";
						if(isset($_REQUEST['dev']))
						{
							$dev = "yes";
						}
						$this->CommonModel->sendiOS($msg,$post['title'],$res['device_token'],'parent', $dev);
					}
				}
			}
		}
		else if($post['type'] == 'teacher')
		{
			$teacher_list = $this->Webservicemodel->teachers_list($post['branchid']);
			if($teacher_list)
			{
				foreach ($teacher_list as $t) 
				{
					$res = $this->Webservicemodel->getTeacherDetail($t->teacherid);
					if($res['reg_id'])
					{
						$msg['message'] = $post['description'];
						$msg['userType'] = 'Teacher';
						$msg['userid'] = $t->teacherid;
						$msg['action'] = 'notification';
						$msg['branchid'] = $post['branchid'];
						$this->sendNotification($msg,$post['title'],$res['reg_id']);
					}
				}
			}
		}
		$result_json = array(
						'status' => 'success',
						'response' => 'Notices added.'
			);
		echo json_encode($result_json);
	}
	function deletenotice()
	{
		$notice_id = $_REQUEST['notice_id'];
		$this->Webservicemodel->deletenotice($notice_id);
		$result_json = array(
						'status' => 'success',
						'response' => 'Notices deleted.'
			);
		echo json_encode($result_json);
	}
	function updateNotice()
	{
		$post['title'] = $_REQUEST['title'];
		$post['description'] = $_REQUEST['description'];
		$post['type'] = $_REQUEST['type'];
		$post['date'] = $_REQUEST['date'];
		$notice_id = $_REQUEST['notice_id'];
		$this->Webservicemodel->updateNotice($post,$notice_id);
		$result_json = array(
						'status' => 'success',
						'response' => 'Notices updated.'
			);
		echo json_encode($result_json);
	}
	public function teachersTodayAttendance()
	{
		$branchid = $_REQUEST['branchid'];
		$date = '';
		if(isset($_REQUEST['date']))
		{
			$date = $_REQUEST['date'];
		}
		
		$teachers = $this->Webservicemodel->teachersTodayAttendance($branchid,$date); 
		if($teachers)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $teachers 
				);
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Teacher found.'
			);
		}
		echo json_encode($result_json);
	}
	public function getAllLeavesHistory()
	{
		$branchid = $_REQUEST['branchid'];
		$leaves = $this->Webservicemodel->get_leaves($branchid); 
		if($leaves)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $leaves 
				);
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Leave found.'
			);
		}
		echo json_encode($result_json);
	}
	public function getTeacherLeavesList()
	{
		$teacherid = $_REQUEST['teacherid'];
		$leaves = $this->Webservicemodel->getTeacherLeaves($teacherid); 
		if($leaves)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $leaves 
				);
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Leave found.'
			);
		}
		echo json_encode($result_json);
	}
	public function approveUserLeave()
	{
		$leave_id = $_REQUEST['leaveid'];
		$status = $_REQUEST['status'];
		$leaves = $this->Webservicemodel->approveLeaves($leave_id,$status); 
		if($status == 'approved')
		{
			$result_json = array(
					'status' => 'success',
					'response' => 'Leave approved.' 
				);
		}
		else
		{
			$result_json = array(
				'status' => 'success',
				'response' => 'Leave not approved.' 
			);
		}
		echo json_encode($result_json);
	}
	function getPrincipalDocExpiry()
	{
		$principalid = $_REQUEST['principalid'];
		$principal_data = $this->Webservicemodel->getPrincipalDocExpiry($principalid);
		$start = strtotime(date('Y-m-d'));
		if($principal_data->iqama_expiry && $principal_data->iqama_expiry !="0000-00-00")
		{
			$iqama_expiry = explode("/", $principal_data->iqama_expiry);
			$y = $iqama_expiry[0];
			$m = $iqama_expiry[1];
			$d = $iqama_expiry[2];
			$end = jdtogregorian((int)((11 * $y + 3) / 30) + 354 * $y + 30 * $m - (int)(($m - 1) / 2) + $d + 1948440 - 385);
			$end = strtotime(date('Y-m-d',strtotime($end)));

			$iqama_expiry_count = ceil(abs($end - $start) / 86400);
			$principal_data->iqama_expiry_count = $iqama_expiry_count;
		}
		if($principal_data->passport_expiry != '0000-00-00')
		{
			$end = strtotime($principal_data->passport_expiry);
			$passport_expiry_count = ceil(abs($end - $start) / 86400);
			$principal_data->passport_expiry_count = $passport_expiry_count;
		}
		
		if($principal_data)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $principal_data 
				);
		}
		else{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Teacher found.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	function teacherOfmonth()
	{
		$branchid = $_REQUEST['branchid'];
		$teacher = $this->Webservicemodel->teacherOfmonth($branchid);
		if($teacher)
		{
			$current_month = date('m');
			$teacher_info = array();
			foreach ($teacher as $t)
			{
				if($t->month == $current_month)
				{
					$teacher_info['month'] = $t->month;
					$teacher_info['details'] = $t->details;
					$teacher_info['teacher_name'] = $t->teacher_name;
					$teacher_info['month_name'] = $t->month_name;
					if($t->picture)
					{
						$teacher_info['picture'] = str_replace(" ","%20",base_url()."assets/uploads/pictures/".$t->picture);
					}
					else
					{
						$teacher_info['picture'] = str_replace(" ","%20",base_url()."assets/uploads/pictures/no-image.png");
					}
					
					$result_json = array(
								'status' => 'success',
								'response' => $teacher_info
					);
				}
				else
				{
					$result_json = array(
								'status' => 'failed',
								'response' => 'No Teacher found.'
					);
				}
			}
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Teacher found.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	function teacherOfmonthlisting()
	{
		$branchid = $_REQUEST['branchid'];
		$teacher = $this->Webservicemodel->teacherOfmonth($branchid);
		if($teacher)
		{
			$current_month = date('m');
			$teacher_info = array();
			foreach ($teacher as $t)
			{
				if($t->picture)
				{
					$t->picture = str_replace(" ","%20",base_url()."assets/uploads/pictures/".$t->picture);
				}
				else
				{
					$t->picture = str_replace(" ","%20",base_url()."assets/uploads/pictures/no-image.png");
				}
			}
			$result_json = array(
							'status' => 'success',
							'response' => $teacher
				);
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Teacher found.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	function markTeacherAttendance()
	{
//		$teacher[1] = 'P';
//		$teacher[2] = 'A';
//		$teacher[3] = 'B';
//		$teachers = $teacher;
//		$note[1] = 'he is present';
//		$note[2] = 'he is absent';
//		$note[3] = 'he is on bunk';
//		print_R(json_encode($teacher));
//		print_R(json_encode($note));die;
		$teachers = json_decode($_REQUEST['teacher_array']);
		$note = json_decode($_REQUEST['note_array']);
		if($teachers)
		{
			foreach ($teachers as $teacherid=> $t) 
			{
				$post['teacherid'] = $teacherid;
				$post['status'] = $t;
				if(isset($note->$teacherid))
				{
					$post['message'] = $note->$teacherid;
				}
				if($post['message'] == "" && $post['status'] == "A")
				{
					$post['message'] = "Why you are absent ?";
				}
				$this->Webservicemodel->markTeacherAttendance($post);
			}
		}	
		$result_json = array(
						'status' => 'success',
						'response' => 'Teacher attendance added.'
			);
		$json = json_encode($result_json);
		echo $json;
	}
	function getParentTeacherLastNotice()
	{
		$branchid = $_REQUEST['branchid'];
		$type = $_REQUEST['type'];
		$notice = $this->Webservicemodel->getParentTeacherLastNotice($branchid,$type);
		if($notice)
		{
			$result_json = array(
						'status' => 'success',
						'response' => $notice
			);
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No notice found.'
			);
		}
		
		$json = json_encode($result_json);
		echo $json;
	}
	public function getTeacherExamsTimetable()
	{
		$teacherid = $_REQUEST['teacherid'];
		$exams = $this->Webservicemodel->getTeacherExamsTimetable($teacherid);
		foreach ($exams as $e) 
		{
			$e->description = strip_tags($e->description);
		}
		if($exams)
		{
			$result_json = array(
						'status' => 'success',
						'response' => $exams
			);
		}
		else
		{
			$result_json = array(
						'status' => 'failed',
						'response' => 'No Exams Timetable found.'
			);
		}
		$json = json_encode($result_json);
		echo $json;
	}
	public function getAppointmentsfromPrincipal()
	{
		$branchid = $_REQUEST['branchid'];
		$appointments = $this->Webservicemodel->getAppointmentsfromPrincipal($branchid); 
		if($appointments)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $appointments
				);
		}
		else
		{
			$result_json = array(
				'status' => 'success',
				'response' => 'Appointments not found.' 
			);
		}
		echo json_encode($result_json);
	}
	function getAppoinmentsfromParents()
	{
		$branchid = $_REQUEST['branchid'];
		$appointments = $this->Webservicemodel->getAppoinmentsfromParents($branchid); 
		if($appointments)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $appointments
				);
		}
		else
		{
			$result_json = array(
				'status' => 'success',
				'response' => 'Appointments not found.' 
			);
		}
		echo json_encode($result_json);
	}
	public function addAppointmentbyPrincipal()
	{
		$post['parent_id'] = $_REQUEST['parent_id'];
		$post['appointment_for'] = $_REQUEST['appointment_for'];
		$post['appointment_date'] = $_REQUEST['appointment_date'];
		$post['description'] = $_REQUEST['description'];
		$post['type'] = 'sent';
		$insert = $this->Webservicemodel->addAppointmentbyPrincipal($post); 
		if($insert)
		{
			$result_json = array(
				'status' => 'success',
				'response' => 'Appointments has been added.' 
			);
		}
		else
		{
			$result_json = array(
				'status' => 'failed',
				'response' => 'Please try again.' 
			);
		}
		echo json_encode($result_json);
	}
	public function addComplainbyPrincipal()
	{
		$post['userid'] = $_REQUEST['userid'];
		$post['complaint_for'] = $_REQUEST['complaint_for'];
		$post['description'] = $_REQUEST['description'];
		$post['date'] = date('Y-m-d');
		$post['sender'] = 'principal';
		$post['receiver'] = $_REQUEST['receiver'];
		
		// send notification to teacher
		if($post['receiver'] == 'teacher')
		{
			$res = $this->CommonModel->getTeacherReg($post['userid']);
			$msg['message'] = $post['description'];
			$msg['userType'] = 'Teacher';
			$msg['userid'] = $post['userid'];
			$msg['action'] = 'complain';
			if($res['reg_id'])
			{
				$this->CommonModel->sendNotification($msg,$post['complaint_for'],$res['reg_id']);
			}
		}
		else if($post['receiver'] == 'parent')
		{
			$res = $this->CommonModel->getParentDetailbyid($post['userid']);
			$msg['message'] = $post['description'];
			$msg['userType'] = 'Parent';
			$msg['userid'] = $post['userid'];
			$msg['action'] = 'complain';
			if($res['reg_id'])
			{
				$this->CommonModel->sendNotification($msg,$post['complaint_for'],$res['reg_id']);
			}
			if($res['device_token'])
			{
				$dev = "";
				if(isset($_REQUEST['dev']))
				{
					$dev = "yes";
				}
				$msg['studentid'] = $post['userid'];
				$this->CommonModel->sendiOS($msg,$post['complaint_for'],$res['device_token'],'parent',$dev);
			}
		}
		
		$insert = $this->Webservicemodel->addComplainbyPrincipal($post); 
		if($insert)
		{
			$result_json = array(
				'status' => 'success',
				'response' => 'Complain has been added.' 
			);
		}
		else
		{
			$result_json = array(
				'status' => 'failed',
				'response' => 'Please try again.' 
			);
		}
		echo json_encode($result_json);
	}
	function getChilds($pr_number)
	{
		$childs = $this->Webservicemodel->getChilds($pr_number); 
		return $childs;
	}
	function getChildsbyid($ptid)
	{
		$childs = $this->Webservicemodel->getChildsbyid($ptid); 
		return $childs;
	}
	
	function confirmAppointment()
	{
		$id = $_REQUEST['appointment_id'];
		$confirm_date = $_REQUEST['confirm_date'];
		$appointments = $this->Webservicemodel->confirmAppointment($confirm_date,$id); 
		if($appointments)
		{
			$result_json = array(
				'status' => 'success',
				'response' => 'Appointments has been updated.' 
			);
		}
		else
		{
			$result_json = array(
				'status' => 'failed',
				'response' => 'Please try again.' 
			);
		}
		echo json_encode($result_json);
	}
	function getStdAttendance()
	{
		$classid = $_REQUEST['classid'];
		$sectionid = $_REQUEST['sectionid'];
		$period = $_REQUEST['period'];
		$date = $_REQUEST['date']; 
		$branchid = $_REQUEST['branchid']; 
		
		$attendance = $this->Webservicemodel->getStdAttendance($classid,$sectionid,$period,$date,$branchid); 
		if($attendance)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $attendance
				);
		}
		else
		{
			$result_json = array(
				'status' => 'success',
				'response' => 'Student attendance not found.' 
			);
		}
		echo json_encode($result_json);
	}
	function getTodayAbsentStudents()
	{
		$branchid = $_REQUEST['branchid'];
		if(isset($_REQUEST['date']))
		{
			$date = $_REQUEST['date'];
		}
		else
		{
			$date = date('Y-m-d');
		}
		$student = $this->Webservicemodel->getTodayAbsentStd($branchid, $date);
		if($student)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $student
				);
		}
		else
		{
			$result_json = array(
				'status' => 'success',
				'response' => 'No Student absent' 
			);
		}
		echo json_encode($result_json);
	}
	function lateComingStudents()
	{
		$branchid = $_REQUEST['branchid'];
		if(isset($_REQUEST['date']))
		{
			$date = $_REQUEST['date'];
		}
		else
		{
			$date = date('Y-m-d');
		}
		$student = $this->Webservicemodel->lateComingStudents($branchid, $date);
		if($student)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $student
				);
		}
		else
		{
			$result_json = array(
				'status' => 'success',
				'response' => 'No Student absent' 
			);
		}
		echo json_encode($result_json);
	}
	public function ProgressReportList()
	{
		$classid = $_REQUEST['classid'];
		$sectionid = $_REQUEST['sectionid'];
		$branchid = $_REQUEST['branchid'];
		$report = $this->Webservicemodel->ProgressReportList($classid,$sectionid,$branchid);
		if($report)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $report
				);
		}
		else
		{
			$result_json = array(
				'status' => 'success',
				'response' => 'No Report found.' 
			);
		}
		echo json_encode($result_json);
	}
	public function studentRankingList()
	{
		$classid = $_REQUEST['classid'];
		$sectionid = $_REQUEST['sectionid'];
		$branchid = $_REQUEST['branchid'];
		$ranking = $this->Webservicemodel->studentRankingList($classid,$sectionid,$branchid);
		if($ranking)
		{
			$result_json = array(
					'status' => 'success',
					'response' => $ranking
				);
		}
		else
		{
			$result_json = array(
				'status' => 'failed',
				'response' => 'No Student Ranking found.' 
			);
		}
		echo json_encode($result_json);
	}
	function getClassSections()
	{
		$resp['class_list'] = $this->Webservicemodel->getClasses();
		$resp['section_list'] = $this->Webservicemodel->getSections();
		if($resp)
		{
			$res = array(
					'status' => 'success',
					'response' => $resp
				);
		}
		else
		{
			$result_json = array(
				'status' => 'success',
				'response' => 'No Class Section found.' 
			);
		}
		echo json_encode($res);
		
	}
	function getTeachersStudents()
	{
		$branchid = $_REQUEST['branchid'];
		$classid = $_REQUEST['classid'];
		$sectionid = $_REQUEST['sectionid'];
		$resp['student_list'] = $this->Webservicemodel->getStudentsList($branchid,$classid,$sectionid);
		if($resp)
		{
			$res = array(
					'status' => 'success',
					'response' => $resp
				);
		}
		else
		{
			$result_json = array(
				'status' => 'success',
				'response' => 'No Class Section found.' 
			);
		}
		echo json_encode($res);
		
	}
	function sendNotification($message,$title,$reg_id)
	{
		
		$url = 'https://fcm.googleapis.com/fcm/send';
 
       
		$message['title'] = $title;
		
		$fields = array(
            'to' => $reg_id,
            'data' => $message,
        );
		//print_R($fields);die;
		//echo json_encode($fields);die;
        // Set POST variables
        $url = 'https://fcm.googleapis.com/fcm/send';
 
        $headers = array(
            'Authorization: key=' . FIREBASE_API_KEY,
            'Content-Type: application/json'
        );
        // Open connection
        $ch = curl_init();
 
        // Set the url, number of POST vars, POST data
        curl_setopt($ch, CURLOPT_URL, $url);
 
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
 
        // Disabling SSL Certificate support temporarly
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
 
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($fields));
 
        // Execute post
        $result = curl_exec($ch);
        if ($result === FALSE) {
            die('Curl failed: ' . curl_error($ch));
        }
 
        // Close connection
        curl_close($ch);
		return $result;
	} 
	function parent_list()
	{
		$branchid = $_REQUEST['branchid'];
		$parent_list = $this->Webservicemodel->parent_list($branchid);
		if($parent_list)
		{
			$res = array(
					'status' => 'success',
					'response' => $parent_list
				);
		}
		else
		{
			$result_json = array(
				'status' => 'success',
				'response' => 'No Parent found.' 
			);
		}
		echo json_encode($res);
	}
	function teachers_list()
	{
		$branchid = $_REQUEST['branchid'];
		$teacher_list = $this->Webservicemodel->teachers_list($branchid);
		if($teacher_list)
		{
			$res = array(
					'status' => 'success',
					'response' => $teacher_list
				);
		}
		else
		{
			$result_json = array(
				'status' => 'success',
				'response' => 'No Teacher found.' 
			);
		}
		echo json_encode($res);
	}
	function testapi()
	{
		$message = $_REQUEST['msg'];
		//$msm['message'] = $message;
		$reg_id = 'dyll3XyooE4:APA91bEi28pFiO0gvsPjXDnp-F-J6QntLy-jwUWXEOIlwFebgzCLrl_BiF91FEBQt-nBY7fNIPcqcvN3UWY5AsklEEWK-dGvxYymt7WJm9ldcb18MQ_YeIv6DsHwvV24oQm3OlR-UstM';
		//$this->sendNotification($message,'Absent Student',$reg_id);
		die('done');
	}
	function iostest()
	{
		$msg['childs'] = $this->getChilds(3126);
		$msg['message'] = 'hello Qurat';
		$msg['action'] = 'Parent';
		$msg['userid'] = 1;
		$this->CommonModel->sendiOS($msg,'testing','CA058B7416CAB6658CA2E91A7C50FE112FC4885E1C923A30F9E79B0E19D6E76D','parent','yes');
	}
	function get_gallery_list()
	{
		$category_name = $_REQUEST['category'];
		$image_arr = array();
		$images = $this->Webservicemodel->getGalleryImages($category_name);
		if($images)
		{
			foreach ($images as $img)
			{
				$gallery_img = unserialize($img->my_pictures);
				if($gallery_img)
				{
					foreach ($gallery_img as $img) 
					{
						$title = str_replace(" ", "", $img);
						$image_arr['images'][] = str_replace(" ","%20", base_url()."/assets/grocery_crud_multiuploader/GC_uploads/pictures/".$img);
					}
				}
				//$image_arr['image_path'] = $img->title;
				break;
			}
			$result_json = array(
				'status' => 'success',
				'response' => $image_arr 
			);
		}
		else {
			$result_json = array(
							'status' => 'failed',
							'response' => "" 
						);
		}
		echo json_encode($result_json);
	}
}
